/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ses.Ses2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.ses.SesClient;

@org.apache.camel.spi.annotations.Component(value="aws2-ses")
public class Ses2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Ses2Component.class);
    @Metadata
    private Ses2Configuration configuration = new Ses2Configuration();

    public Ses2Component() {
        this(null);
    }

    public Ses2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Ses2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("From must be specified.");
        }
        Ses2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Ses2Configuration();
        configuration.setFrom(remaining);
        Ses2Endpoint endpoint = new Ses2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration, endpoint);
        }
        if (configuration.getAmazonSESClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSESClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Ses2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Ses2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Ses2Configuration configuration, Ses2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonSESClient())) {
            LOG.debug("Looking for an SesClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(SesClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one SesClient instance in the registry");
                configuration.setAmazonSESClient((SesClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No SesClient instance in the registry");
            }
        } else {
            LOG.debug("SesClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

