/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ReceiptRuleNamesListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReorderReceiptRuleSetRequest
extends SesRequest
implements ToCopyableBuilder<Builder, ReorderReceiptRuleSetRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(ReorderReceiptRuleSetRequest.getter(ReorderReceiptRuleSetRequest::ruleSetName)).setter(ReorderReceiptRuleSetRequest.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleNames").getter(ReorderReceiptRuleSetRequest.getter(ReorderReceiptRuleSetRequest::ruleNames)).setter(ReorderReceiptRuleSetRequest.setter(Builder::ruleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD, RULE_NAMES_FIELD));
    private final String ruleSetName;
    private final List<String> ruleNames;

    private ReorderReceiptRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.ruleNames = builder.ruleNames;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public boolean hasRuleNames() {
        return this.ruleNames != null && !(this.ruleNames instanceof SdkAutoConstructList);
    }

    public List<String> ruleNames() {
        return this.ruleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReorderReceiptRuleSetRequest)) {
            return false;
        }
        ReorderReceiptRuleSetRequest other = (ReorderReceiptRuleSetRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleNames(), other.ruleNames());
    }

    public String toString() {
        return ToString.builder((String)"ReorderReceiptRuleSetRequest").add("RuleSetName", (Object)this.ruleSetName()).add("RuleNames", this.ruleNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "RuleNames": {
                return Optional.ofNullable(clazz.cast(this.ruleNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReorderReceiptRuleSetRequest, T> g) {
        return obj -> g.apply((ReorderReceiptRuleSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReorderReceiptRuleSetRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.ruleNames(model.ruleNames);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final Collection<String> getRuleNames() {
            return this.ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String ... ruleNames) {
            this.ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReorderReceiptRuleSetRequest build() {
            return new ReorderReceiptRuleSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReorderReceiptRuleSetRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleNames(Collection<String> var1);

        public Builder ruleNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

