/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.DsnAction;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecipientDsnFields
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecipientDsnFields> {
    private static final SdkField<String> FINAL_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecipientDsnFields.getter(RecipientDsnFields::finalRecipient)).setter(RecipientDsnFields.setter(Builder::finalRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalRecipient").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecipientDsnFields.getter(RecipientDsnFields::actionAsString)).setter(RecipientDsnFields.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> REMOTE_MTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecipientDsnFields.getter(RecipientDsnFields::remoteMta)).setter(RecipientDsnFields.setter(Builder::remoteMta)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteMta").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecipientDsnFields.getter(RecipientDsnFields::status)).setter(RecipientDsnFields.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DIAGNOSTIC_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecipientDsnFields.getter(RecipientDsnFields::diagnosticCode)).setter(RecipientDsnFields.setter(Builder::diagnosticCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiagnosticCode").build()}).build();
    private static final SdkField<Instant> LAST_ATTEMPT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RecipientDsnFields.getter(RecipientDsnFields::lastAttemptDate)).setter(RecipientDsnFields.setter(Builder::lastAttemptDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptDate").build()}).build();
    private static final SdkField<List<ExtensionField>> EXTENSION_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RecipientDsnFields.getter(RecipientDsnFields::extensionFields)).setter(RecipientDsnFields.setter(Builder::extensionFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINAL_RECIPIENT_FIELD, ACTION_FIELD, REMOTE_MTA_FIELD, STATUS_FIELD, DIAGNOSTIC_CODE_FIELD, LAST_ATTEMPT_DATE_FIELD, EXTENSION_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String finalRecipient;
    private final String action;
    private final String remoteMta;
    private final String status;
    private final String diagnosticCode;
    private final Instant lastAttemptDate;
    private final List<ExtensionField> extensionFields;

    private RecipientDsnFields(BuilderImpl builder) {
        this.finalRecipient = builder.finalRecipient;
        this.action = builder.action;
        this.remoteMta = builder.remoteMta;
        this.status = builder.status;
        this.diagnosticCode = builder.diagnosticCode;
        this.lastAttemptDate = builder.lastAttemptDate;
        this.extensionFields = builder.extensionFields;
    }

    public String finalRecipient() {
        return this.finalRecipient;
    }

    public DsnAction action() {
        return DsnAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String remoteMta() {
        return this.remoteMta;
    }

    public String status() {
        return this.status;
    }

    public String diagnosticCode() {
        return this.diagnosticCode;
    }

    public Instant lastAttemptDate() {
        return this.lastAttemptDate;
    }

    public boolean hasExtensionFields() {
        return this.extensionFields != null && !(this.extensionFields instanceof SdkAutoConstructList);
    }

    public List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.finalRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteMta());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnosticCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientDsnFields)) {
            return false;
        }
        RecipientDsnFields other = (RecipientDsnFields)obj;
        return Objects.equals(this.finalRecipient(), other.finalRecipient()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.remoteMta(), other.remoteMta()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.diagnosticCode(), other.diagnosticCode()) && Objects.equals(this.lastAttemptDate(), other.lastAttemptDate()) && Objects.equals(this.extensionFields(), other.extensionFields());
    }

    public String toString() {
        return ToString.builder((String)"RecipientDsnFields").add("FinalRecipient", (Object)this.finalRecipient()).add("Action", (Object)this.actionAsString()).add("RemoteMta", (Object)this.remoteMta()).add("Status", (Object)this.status()).add("DiagnosticCode", (Object)this.diagnosticCode()).add("LastAttemptDate", (Object)this.lastAttemptDate()).add("ExtensionFields", this.extensionFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FinalRecipient": {
                return Optional.ofNullable(clazz.cast(this.finalRecipient()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "RemoteMta": {
                return Optional.ofNullable(clazz.cast(this.remoteMta()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DiagnosticCode": {
                return Optional.ofNullable(clazz.cast(this.diagnosticCode()));
            }
            case "LastAttemptDate": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptDate()));
            }
            case "ExtensionFields": {
                return Optional.ofNullable(clazz.cast(this.extensionFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecipientDsnFields, T> g) {
        return obj -> g.apply((RecipientDsnFields)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String finalRecipient;
        private String action;
        private String remoteMta;
        private String status;
        private String diagnosticCode;
        private Instant lastAttemptDate;
        private List<ExtensionField> extensionFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecipientDsnFields model) {
            this.finalRecipient(model.finalRecipient);
            this.action(model.action);
            this.remoteMta(model.remoteMta);
            this.status(model.status);
            this.diagnosticCode(model.diagnosticCode);
            this.lastAttemptDate(model.lastAttemptDate);
            this.extensionFields(model.extensionFields);
        }

        public final String getFinalRecipient() {
            return this.finalRecipient;
        }

        @Override
        public final Builder finalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
            return this;
        }

        public final void setFinalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DsnAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRemoteMta() {
            return this.remoteMta;
        }

        @Override
        public final Builder remoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
            return this;
        }

        public final void setRemoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDiagnosticCode() {
            return this.diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        public final Instant getLastAttemptDate() {
            return this.lastAttemptDate;
        }

        @Override
        public final Builder lastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
            return this;
        }

        public final void setLastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
        }

        public final Collection<ExtensionField.Builder> getExtensionFields() {
            return this.extensionFields != null ? (Collection)this.extensionFields.stream().map(ExtensionField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            this.extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(Consumer<ExtensionField.Builder> ... extensionFields) {
            this.extensionFields(Stream.of(extensionFields).map(c -> (ExtensionField)((ExtensionField.Builder)ExtensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        public RecipientDsnFields build() {
            return new RecipientDsnFields(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecipientDsnFields> {
        public Builder finalRecipient(String var1);

        public Builder action(String var1);

        public Builder action(DsnAction var1);

        public Builder remoteMta(String var1);

        public Builder status(String var1);

        public Builder diagnosticCode(String var1);

        public Builder lastAttemptDate(Instant var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);

        public Builder extensionFields(Consumer<ExtensionField.Builder> ... var1);
    }
}

