/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitoringResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, UpdateMonitoringResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMonitoringResponse.getter(UpdateMonitoringResponse::clusterArn)).setter(UpdateMonitoringResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMonitoringResponse.getter(UpdateMonitoringResponse::clusterOperationArn)).setter(UpdateMonitoringResponse.setter(Builder::clusterOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_OPERATION_ARN_FIELD));
    private final String clusterArn;
    private final String clusterOperationArn;

    private UpdateMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.clusterOperationArn = builder.clusterOperationArn;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String clusterOperationArn() {
        return this.clusterOperationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterOperationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringResponse)) {
            return false;
        }
        UpdateMonitoringResponse other = (UpdateMonitoringResponse)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterOperationArn(), other.clusterOperationArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMonitoringResponse").add("ClusterArn", (Object)this.clusterArn()).add("ClusterOperationArn", (Object)this.clusterOperationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterOperationArn": {
                return Optional.ofNullable(clazz.cast(this.clusterOperationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringResponse, T> g) {
        return obj -> g.apply((UpdateMonitoringResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterOperationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringResponse model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.clusterOperationArn(model.clusterOperationArn);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterOperationArn() {
            return this.clusterOperationArn;
        }

        @Override
        public final Builder clusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
            return this;
        }

        public final void setClusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
        }

        @Override
        public UpdateMonitoringResponse build() {
            return new UpdateMonitoringResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitoringResponse> {
        public Builder clusterArn(String var1);

        public Builder clusterOperationArn(String var1);
    }
}

