/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.11.0", label="dataformat,transformation,file", title="Zip File")
@XmlRootElement(name="zipFile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ZipFileDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String usingIterator;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowEmptyDirectory;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String preservePathElements;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Long", defaultValue="1073741824")
    private String maxDecompressedSize;

    public ZipFileDataFormat() {
        super("zipFile");
    }

    private ZipFileDataFormat(Builder builder) {
        this();
        this.usingIterator = builder.usingIterator;
        this.allowEmptyDirectory = builder.allowEmptyDirectory;
        this.preservePathElements = builder.preservePathElements;
        this.maxDecompressedSize = builder.maxDecompressedSize;
    }

    public String getUsingIterator() {
        return this.usingIterator;
    }

    public String getAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public String getPreservePathElements() {
        return this.preservePathElements;
    }

    public String getMaxDecompressedSize() {
        return this.maxDecompressedSize;
    }

    public void setUsingIterator(String usingIterator) {
        this.usingIterator = usingIterator;
    }

    public void setAllowEmptyDirectory(String allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    public void setPreservePathElements(String preservePathElements) {
        this.preservePathElements = preservePathElements;
    }

    public void setMaxDecompressedSize(String maxDecompressedSize) {
        this.maxDecompressedSize = maxDecompressedSize;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ZipFileDataFormat> {
        private String usingIterator;
        private String allowEmptyDirectory;
        private String preservePathElements;
        private String maxDecompressedSize;

        public Builder usingIterator(String usingIterator) {
            this.usingIterator = usingIterator;
            return this;
        }

        public Builder usingIterator(boolean usingIterator) {
            this.usingIterator = Boolean.toString(usingIterator);
            return this;
        }

        public Builder allowEmptyDirectory(String allowEmptyDirectory) {
            this.allowEmptyDirectory = allowEmptyDirectory;
            return this;
        }

        public Builder allowEmptyDirectory(boolean allowEmptyDirectory) {
            this.allowEmptyDirectory = Boolean.toString(allowEmptyDirectory);
            return this;
        }

        public Builder preservePathElements(String preservePathElements) {
            this.preservePathElements = preservePathElements;
            return this;
        }

        public Builder preservePathElements(boolean preservePathElements) {
            this.preservePathElements = Boolean.toString(preservePathElements);
            return this;
        }

        public Builder maxDecompressedSize(String maxDecompressedSize) {
            this.maxDecompressedSize = maxDecompressedSize;
            return this;
        }

        public Builder maxDecompressedSize(long maxDecompressedSize) {
            this.maxDecompressedSize = Long.toString(maxDecompressedSize);
            return this;
        }

        @Override
        public ZipFileDataFormat end() {
            return new ZipFileDataFormat(this);
        }
    }
}

