/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.iam.IAM2Operations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamClient;

@UriParams
public class IAM2Configuration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam
    private IamClient iamClient;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam
    @Metadata(required=true)
    private IAM2Operations operation;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam
    private String proxyHost;
    @UriParam
    private Integer proxyPort;
    @UriParam(defaultValue="aws-global")
    private String region = Region.AWS_GLOBAL.id();
    @UriParam(defaultValue="false")
    private boolean pojoRequest;
    @UriParam(defaultValue="false")
    private boolean trustAllCertificates;
    @UriParam(label="common", defaultValue="true")
    private boolean autoDiscoverClient = true;

    public IamClient getIamClient() {
        return this.iamClient;
    }

    public void setIamClient(IamClient iamClient) {
        this.iamClient = iamClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public IAM2Operations getOperation() {
        return this.operation;
    }

    public void setOperation(IAM2Operations operation) {
        this.operation = operation;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public IAM2Configuration copy() {
        try {
            return (IAM2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

