/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry;
import software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpenIdConnectProvidersResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListOpenIdConnectProvidersResponse> {
    private static final SdkField<List<OpenIDConnectProviderListEntry>> OPEN_ID_CONNECT_PROVIDER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpenIDConnectProviderList").getter(ListOpenIdConnectProvidersResponse.getter(ListOpenIdConnectProvidersResponse::openIDConnectProviderList)).setter(ListOpenIdConnectProvidersResponse.setter(Builder::openIDConnectProviderList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenIDConnectProviderListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_ID_CONNECT_PROVIDER_LIST_FIELD));
    private final List<OpenIDConnectProviderListEntry> openIDConnectProviderList;

    private ListOpenIdConnectProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderList = builder.openIDConnectProviderList;
    }

    public boolean hasOpenIDConnectProviderList() {
        return this.openIDConnectProviderList != null && !(this.openIDConnectProviderList instanceof SdkAutoConstructList);
    }

    public List<OpenIDConnectProviderListEntry> openIDConnectProviderList() {
        return this.openIDConnectProviderList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenIdConnectProvidersResponse)) {
            return false;
        }
        ListOpenIdConnectProvidersResponse other = (ListOpenIdConnectProvidersResponse)((Object)obj);
        return Objects.equals(this.openIDConnectProviderList(), other.openIDConnectProviderList());
    }

    public String toString() {
        return ToString.builder((String)"ListOpenIdConnectProvidersResponse").add("OpenIDConnectProviderList", this.openIDConnectProviderList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderList": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectProviderList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpenIdConnectProvidersResponse, T> g) {
        return obj -> g.apply((ListOpenIdConnectProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<OpenIDConnectProviderListEntry> openIDConnectProviderList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenIdConnectProvidersResponse model) {
            super(model);
            this.openIDConnectProviderList(model.openIDConnectProviderList);
        }

        public final Collection<OpenIDConnectProviderListEntry.Builder> getOpenIDConnectProviderList() {
            return this.openIDConnectProviderList != null ? (Collection)this.openIDConnectProviderList.stream().map(OpenIDConnectProviderListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder openIDConnectProviderList(Collection<OpenIDConnectProviderListEntry> openIDConnectProviderList) {
            this.openIDConnectProviderList = OpenIDConnectProviderListTypeCopier.copy(openIDConnectProviderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIDConnectProviderList(OpenIDConnectProviderListEntry ... openIDConnectProviderList) {
            this.openIDConnectProviderList(Arrays.asList(openIDConnectProviderList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIDConnectProviderList(Consumer<OpenIDConnectProviderListEntry.Builder> ... openIDConnectProviderList) {
            this.openIDConnectProviderList(Stream.of(openIDConnectProviderList).map(c -> (OpenIDConnectProviderListEntry)((OpenIDConnectProviderListEntry.Builder)OpenIDConnectProviderListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOpenIDConnectProviderList(Collection<OpenIDConnectProviderListEntry.BuilderImpl> openIDConnectProviderList) {
            this.openIDConnectProviderList = OpenIDConnectProviderListTypeCopier.copyFromBuilder(openIDConnectProviderList);
        }

        @Override
        public ListOpenIdConnectProvidersResponse build() {
            return new ListOpenIdConnectProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpenIdConnectProvidersResponse> {
        public Builder openIDConnectProviderList(Collection<OpenIDConnectProviderListEntry> var1);

        public Builder openIDConnectProviderList(OpenIDConnectProviderListEntry ... var1);

        public Builder openIDConnectProviderList(Consumer<OpenIDConnectProviderListEntry.Builder> ... var1);
    }
}

