/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Endpoint;
import org.apache.camel.component.aws2.iam.IAM2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.services.iam.model.AddUserToGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;
import software.amazon.awssdk.services.iam.model.CreateGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupRequest;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupResponse;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyResponse;

public class IAM2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IAM2Producer.class);
    private transient String iamProducerToString;

    public IAM2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listAccessKeys: {
                this.listAccessKeys(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createAccessKey: {
                this.createAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteAccessKey: {
                this.deleteAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case updateAccessKey: {
                this.updateAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createUser: {
                this.createUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteUser: {
                this.deleteUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case getUser: {
                this.getUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case listUsers: {
                this.listUsers(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createGroup: {
                this.createGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteGroup: {
                this.deleteGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case listGroups: {
                this.listGroups(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case addUserToGroup: {
                this.addUserToGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case removeUserFromGroup: {
                this.removeUserFromGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private IAM2Operations determineOperation(Exchange exchange) {
        IAM2Operations operation = (IAM2Operations)((Object)exchange.getIn().getHeader("CamelAwsIAMOperation", IAM2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected IAM2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.iamProducerToString == null) {
            this.iamProducerToString = "IAMProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.iamProducerToString;
    }

    public IAM2Endpoint getEndpoint() {
        return (IAM2Endpoint)super.getEndpoint();
    }

    private void listAccessKeys(IamClient iamClient, Exchange exchange) {
        ListAccessKeysResponse response;
        try {
            response = iamClient.listAccessKeys();
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Access Keys command returned the error code {}", (Object)ase.getMessage());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void createUser(IamClient iamClient, Exchange exchange) {
        CreateUserResponse result;
        CreateUserRequest.Builder builder = CreateUserRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        builder.userName(userName);
        try {
            result = iamClient.createUser((CreateUserRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create user command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteUser(IamClient iamClient, Exchange exchange) {
        DeleteUserResponse result;
        DeleteUserRequest.Builder builder = DeleteUserRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        builder.userName(userName);
        try {
            result = iamClient.deleteUser((DeleteUserRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete user command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void getUser(IamClient iamClient, Exchange exchange) {
        GetUserResponse result;
        GetUserRequest.Builder builder = GetUserRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        builder.userName(userName);
        try {
            result = iamClient.getUser((GetUserRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("get user command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listUsers(IamClient iamClient, Exchange exchange) {
        ListUsersResponse result;
        try {
            result = iamClient.listUsers();
        }
        catch (AwsServiceException ase) {
            LOG.trace("List users command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createAccessKey(IamClient iamClient, Exchange exchange) {
        CreateAccessKeyResponse result;
        CreateAccessKeyRequest.Builder builder = CreateAccessKeyRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            builder.userName(userName);
        }
        try {
            result = iamClient.createAccessKey((CreateAccessKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Access Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteAccessKey(IamClient iamClient, Exchange exchange) {
        DeleteAccessKeyResponse result;
        DeleteAccessKeyRequest.Builder builder = DeleteAccessKeyRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        builder.accessKeyId(accessKeyId);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            builder.userName(userName);
        }
        try {
            result = iamClient.deleteAccessKey((DeleteAccessKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete Access Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateAccessKey(IamClient iamClient, Exchange exchange) {
        UpdateAccessKeyResponse result;
        UpdateAccessKeyRequest.Builder builder = UpdateAccessKeyRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        builder.accessKeyId(accessKeyId);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus"))) {
            throw new IllegalArgumentException("Access Key status must be specified");
        }
        String status = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus", String.class);
        builder.status(StatusType.fromValue((String)status));
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            builder.userName(userName);
        }
        try {
            result = iamClient.updateAccessKey((UpdateAccessKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Update Access Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createGroup(IamClient iamClient, Exchange exchange) {
        CreateGroupResponse result;
        CreateGroupRequest.Builder builder = CreateGroupRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        builder.groupName(groupName);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupPath"))) {
            String groupPath = (String)exchange.getIn().getHeader("CamelAwsIAMGroupPath", String.class);
            builder.path(groupPath);
        }
        try {
            result = iamClient.createGroup((CreateGroupRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Group command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteGroup(IamClient iamClient, Exchange exchange) {
        DeleteGroupResponse result;
        DeleteGroupRequest.Builder builder = DeleteGroupRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        builder.groupName(groupName);
        try {
            result = iamClient.deleteGroup((DeleteGroupRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete Group command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listGroups(IamClient iamClient, Exchange exchange) {
        ListGroupsResponse result;
        try {
            result = iamClient.listGroups();
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Groups command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void addUserToGroup(IamClient iamClient, Exchange exchange) {
        AddUserToGroupResponse result;
        AddUserToGroupRequest.Builder builder = AddUserToGroupRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        builder.groupName(groupName);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        builder.userName(userName);
        try {
            result = iamClient.addUserToGroup((AddUserToGroupRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Add User To Group command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void removeUserFromGroup(IamClient iamClient, Exchange exchange) {
        RemoveUserFromGroupResponse result;
        RemoveUserFromGroupRequest.Builder builder = RemoveUserFromGroupRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        builder.groupName(groupName);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        builder.userName(userName);
        try {
            result = iamClient.removeUserFromGroup((RemoveUserFromGroupRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Remove User From Group command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = IAM2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

