/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNodegroupVersionRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::clusterName)).setter(UpdateNodegroupVersionRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::nodegroupName)).setter(UpdateNodegroupVersionRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::version)).setter(UpdateNodegroupVersionRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::releaseVersion)).setter(UpdateNodegroupVersionRequest.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::force)).setter(UpdateNodegroupVersionRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::clientRequestToken)).setter(UpdateNodegroupVersionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODEGROUP_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, FORCE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String clusterName;
    private final String nodegroupName;
    private final String version;
    private final String releaseVersion;
    private final Boolean force;
    private final String clientRequestToken;

    private UpdateNodegroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.force = builder.force;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String nodegroupName() {
        return this.nodegroupName;
    }

    public String version() {
        return this.version;
    }

    public String releaseVersion() {
        return this.releaseVersion;
    }

    public Boolean force() {
        return this.force;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupVersionRequest)) {
            return false;
        }
        UpdateNodegroupVersionRequest other = (UpdateNodegroupVersionRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releaseVersion(), other.releaseVersion()) && Objects.equals(this.force(), other.force()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNodegroupVersionRequest").add("ClusterName", (Object)this.clusterName()).add("NodegroupName", (Object)this.nodegroupName()).add("Version", (Object)this.version()).add("ReleaseVersion", (Object)this.releaseVersion()).add("Force", (Object)this.force()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
            case "force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupVersionRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodegroupName;
        private String version;
        private String releaseVersion;
        private Boolean force;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupVersionRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodegroupName(model.nodegroupName);
            this.version(model.version);
            this.releaseVersion(model.releaseVersion);
            this.force(model.force);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupVersionRequest build() {
            return new UpdateNodegroupVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
        public Builder clusterName(String var1);

        public Builder nodegroupName(String var1);

        public Builder version(String var1);

        public Builder releaseVersion(String var1);

        public Builder force(Boolean var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

