/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Producer;
import org.apache.camel.component.aws2.eks.client.EKS2ClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.eks.EksClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-eks", title="AWS 2 Elastic Kubernetes Service (EKS)", syntax="aws2-eks:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class EKS2Endpoint
extends ScheduledPollEndpoint {
    private EksClient eksClient;
    @UriParam
    private EKS2Configuration configuration;

    public EKS2Endpoint(String uri, Component component, EKS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EKS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.eksClient = this.configuration.getEksClient() != null ? this.configuration.getEksClient() : EKS2ClientFactory.getEksClient(this.configuration).getEksClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getEksClient()) && this.eksClient != null) {
            this.eksClient.close();
        }
        super.doStop();
    }

    public EKS2Configuration getConfiguration() {
        return this.configuration;
    }

    public EksClient getEksClient() {
        return this.eksClient;
    }
}

