/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ExportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportSummary> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportArn").getter(ExportSummary.getter(ExportSummary::exportArn)).setter(ExportSummary.setter(Builder::exportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(ExportSummary.getter(ExportSummary::exportStatusAsString)).setter(ExportSummary.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD, EXPORT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportArn;
    private final String exportStatus;

    private ExportSummary(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportStatus = builder.exportStatus;
    }

    public String exportArn() {
        return this.exportArn;
    }

    public ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public String exportStatusAsString() {
        return this.exportStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSummary)) {
            return false;
        }
        ExportSummary other = (ExportSummary)obj;
        return Objects.equals(this.exportArn(), other.exportArn()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ExportSummary").add("ExportArn", (Object)this.exportArn()).add("ExportStatus", (Object)this.exportStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportArn": {
                return Optional.ofNullable(clazz.cast(this.exportArn()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSummary, T> g) {
        return obj -> g.apply((ExportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportArn;
        private String exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSummary model) {
            this.exportArn(model.exportArn);
            this.exportStatus(model.exportStatus);
        }

        public final String getExportArn() {
            return this.exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        public ExportSummary build() {
            return new ExportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportSummary> {
        public Builder exportArn(String var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);
    }
}

