/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamRecord> {
    private static final SdkField<Instant> APPROXIMATE_CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApproximateCreationDateTime").getter(StreamRecord.getter(StreamRecord::approximateCreationDateTime)).setter(StreamRecord.setter(Builder::approximateCreationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateCreationDateTime").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Keys").getter(StreamRecord.getter(StreamRecord::keys)).setter(StreamRecord.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> NEW_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("NewImage").getter(StreamRecord.getter(StreamRecord::newImage)).setter(StreamRecord.setter(Builder::newImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewImage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> OLD_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OldImage").getter(StreamRecord.getter(StreamRecord::oldImage)).setter(StreamRecord.setter(Builder::oldImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldImage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SequenceNumber").getter(StreamRecord.getter(StreamRecord::sequenceNumber)).setter(StreamRecord.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()}).build();
    private static final SdkField<Long> SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeBytes").getter(StreamRecord.getter(StreamRecord::sizeBytes)).setter(StreamRecord.setter(Builder::sizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()}).build();
    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamViewType").getter(StreamRecord.getter(StreamRecord::streamViewTypeAsString)).setter(StreamRecord.setter(Builder::streamViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamViewType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_CREATION_DATE_TIME_FIELD, KEYS_FIELD, NEW_IMAGE_FIELD, OLD_IMAGE_FIELD, SEQUENCE_NUMBER_FIELD, SIZE_BYTES_FIELD, STREAM_VIEW_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant approximateCreationDateTime;
    private final Map<String, AttributeValue> keys;
    private final Map<String, AttributeValue> newImage;
    private final Map<String, AttributeValue> oldImage;
    private final String sequenceNumber;
    private final Long sizeBytes;
    private final String streamViewType;

    private StreamRecord(BuilderImpl builder) {
        this.approximateCreationDateTime = builder.approximateCreationDateTime;
        this.keys = builder.keys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
        this.sizeBytes = builder.sizeBytes;
        this.streamViewType = builder.streamViewType;
    }

    public Instant approximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> keys() {
        return this.keys;
    }

    public boolean hasNewImage() {
        return this.newImage != null && !(this.newImage instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> newImage() {
        return this.newImage;
    }

    public boolean hasOldImage() {
        return this.oldImage != null && !(this.oldImage instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> oldImage() {
        return this.oldImage;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Long sizeBytes() {
        return this.sizeBytes;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewImage() ? this.newImage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOldImage() ? this.oldImage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord)obj;
        return Objects.equals(this.approximateCreationDateTime(), other.approximateCreationDateTime()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && this.hasNewImage() == other.hasNewImage() && Objects.equals(this.newImage(), other.newImage()) && this.hasOldImage() == other.hasOldImage() && Objects.equals(this.oldImage(), other.oldImage()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.sizeBytes(), other.sizeBytes()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamRecord").add("ApproximateCreationDateTime", (Object)this.approximateCreationDateTime()).add("Keys", this.hasKeys() ? this.keys() : null).add("NewImage", this.hasNewImage() ? this.newImage() : null).add("OldImage", this.hasOldImage() ? this.oldImage() : null).add("SequenceNumber", (Object)this.sequenceNumber()).add("SizeBytes", (Object)this.sizeBytes()).add("StreamViewType", (Object)this.streamViewTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.approximateCreationDateTime()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "NewImage": {
                return Optional.ofNullable(clazz.cast(this.newImage()));
            }
            case "OldImage": {
                return Optional.ofNullable(clazz.cast(this.oldImage()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "SizeBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeBytes()));
            }
            case "StreamViewType": {
                return Optional.ofNullable(clazz.cast(this.streamViewTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamRecord, T> g) {
        return obj -> g.apply((StreamRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant approximateCreationDateTime;
        private Map<String, AttributeValue> keys = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> newImage = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> oldImage = DefaultSdkAutoConstructMap.getInstance();
        private String sequenceNumber;
        private Long sizeBytes;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamRecord model) {
            this.approximateCreationDateTime(model.approximateCreationDateTime);
            this.keys(model.keys);
            this.newImage(model.newImage);
            this.oldImage(model.oldImage);
            this.sequenceNumber(model.sequenceNumber);
            this.sizeBytes(model.sizeBytes);
            this.streamViewType(model.streamViewType);
        }

        public final Instant getApproximateCreationDateTime() {
            return this.approximateCreationDateTime;
        }

        @Override
        public final Builder approximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
            return this;
        }

        public final void setApproximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
        }

        public final Map<String, AttributeValue.Builder> getKeys() {
            if (this.keys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keys != null ? CollectionUtils.mapValues(this.keys, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder keys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, AttributeValue.BuilderImpl> keys) {
            this.keys = AttributeMapCopier.copyFromBuilder(keys);
        }

        public final Map<String, AttributeValue.Builder> getNewImage() {
            if (this.newImage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.newImage != null ? CollectionUtils.mapValues(this.newImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder newImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
            return this;
        }

        public final void setNewImage(Map<String, AttributeValue.BuilderImpl> newImage) {
            this.newImage = AttributeMapCopier.copyFromBuilder(newImage);
        }

        public final Map<String, AttributeValue.Builder> getOldImage() {
            if (this.oldImage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.oldImage != null ? CollectionUtils.mapValues(this.oldImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder oldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
            return this;
        }

        public final void setOldImage(Map<String, AttributeValue.BuilderImpl> oldImage) {
            this.oldImage = AttributeMapCopier.copyFromBuilder(oldImage);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Long getSizeBytes() {
            return this.sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType == null ? null : streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public StreamRecord build() {
            return new StreamRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamRecord> {
        public Builder approximateCreationDateTime(Instant var1);

        public Builder keys(Map<String, AttributeValue> var1);

        public Builder newImage(Map<String, AttributeValue> var1);

        public Builder oldImage(Map<String, AttributeValue> var1);

        public Builder sequenceNumber(String var1);

        public Builder sizeBytes(Long var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

