/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponent;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.SequenceNumberProvider;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

public class Ddb2StreamComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Ddb2StreamConfiguration getOrCreateConfiguration(Ddb2StreamComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Ddb2StreamConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Ddb2StreamComponent target = (Ddb2StreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                this.getOrCreateConfiguration(target).setAmazonDynamoDbStreamsClient((DynamoDbStreamsClient)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, DynamoDbStreamsClient.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Ddb2StreamConfiguration)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Ddb2StreamConfiguration.class, (Object)value));
                return true;
            }
            case "iteratortype": 
            case "iteratorType": {
                this.getOrCreateConfiguration(target).setIteratorType((ShardIteratorType)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                this.getOrCreateConfiguration(target).setMaxResultsPerRequest((Integer)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                this.getOrCreateConfiguration(target).setSequenceNumberProvider((SequenceNumberProvider)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, SequenceNumberProvider.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)Ddb2StreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonDynamoDbStreamsClient", DynamoDbStreamsClient.class);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("configuration", Ddb2StreamConfiguration.class);
        answer.put("iteratorType", ShardIteratorType.class);
        answer.put("maxResultsPerRequest", Integer.TYPE);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("sequenceNumberProvider", SequenceNumberProvider.class);
        answer.put("trustAllCertificates", Boolean.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Ddb2StreamComponent target = (Ddb2StreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                return this.getOrCreateConfiguration(target).getAmazonDynamoDbStreamsClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "iteratortype": 
            case "iteratorType": {
                return this.getOrCreateConfiguration(target).getIteratorType();
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                return this.getOrCreateConfiguration(target).getSequenceNumberProvider();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
        }
        return null;
    }
}

