/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination;
import software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKinesisStreamingDestinationResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DescribeKinesisStreamingDestinationResponse.getter(DescribeKinesisStreamingDestinationResponse::tableName)).setter(DescribeKinesisStreamingDestinationResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<KinesisDataStreamDestination>> KINESIS_DATA_STREAM_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KinesisDataStreamDestinations").getter(DescribeKinesisStreamingDestinationResponse.getter(DescribeKinesisStreamingDestinationResponse::kinesisDataStreamDestinations)).setter(DescribeKinesisStreamingDestinationResponse.setter(Builder::kinesisDataStreamDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStreamDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KinesisDataStreamDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, KINESIS_DATA_STREAM_DESTINATIONS_FIELD));
    private final String tableName;
    private final List<KinesisDataStreamDestination> kinesisDataStreamDestinations;

    private DescribeKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.kinesisDataStreamDestinations = builder.kinesisDataStreamDestinations;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasKinesisDataStreamDestinations() {
        return this.kinesisDataStreamDestinations != null && !(this.kinesisDataStreamDestinations instanceof SdkAutoConstructList);
    }

    public final List<KinesisDataStreamDestination> kinesisDataStreamDestinations() {
        return this.kinesisDataStreamDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKinesisDataStreamDestinations() ? this.kinesisDataStreamDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKinesisStreamingDestinationResponse)) {
            return false;
        }
        DescribeKinesisStreamingDestinationResponse other = (DescribeKinesisStreamingDestinationResponse)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && this.hasKinesisDataStreamDestinations() == other.hasKinesisDataStreamDestinations() && Objects.equals(this.kinesisDataStreamDestinations(), other.kinesisDataStreamDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKinesisStreamingDestinationResponse").add("TableName", (Object)this.tableName()).add("KinesisDataStreamDestinations", this.hasKinesisDataStreamDestinations() ? this.kinesisDataStreamDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "KinesisDataStreamDestinations": {
                return Optional.ofNullable(clazz.cast(this.kinesisDataStreamDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((DescribeKinesisStreamingDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private String tableName;
        private List<KinesisDataStreamDestination> kinesisDataStreamDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKinesisStreamingDestinationResponse model) {
            super(model);
            this.tableName(model.tableName);
            this.kinesisDataStreamDestinations(model.kinesisDataStreamDestinations);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final List<KinesisDataStreamDestination.Builder> getKinesisDataStreamDestinations() {
            List<KinesisDataStreamDestination.Builder> result = KinesisDataStreamDestinationsCopier.copyToBuilder(this.kinesisDataStreamDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder kinesisDataStreamDestinations(Collection<KinesisDataStreamDestination> kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations = KinesisDataStreamDestinationsCopier.copy(kinesisDataStreamDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kinesisDataStreamDestinations(KinesisDataStreamDestination ... kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations(Arrays.asList(kinesisDataStreamDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kinesisDataStreamDestinations(Consumer<KinesisDataStreamDestination.Builder> ... kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations(Stream.of(kinesisDataStreamDestinations).map(c -> (KinesisDataStreamDestination)((KinesisDataStreamDestination.Builder)KinesisDataStreamDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKinesisDataStreamDestinations(Collection<KinesisDataStreamDestination.BuilderImpl> kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations = KinesisDataStreamDestinationsCopier.copyFromBuilder(kinesisDataStreamDestinations);
        }

        @Override
        public DescribeKinesisStreamingDestinationResponse build() {
            return new DescribeKinesisStreamingDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKinesisStreamingDestinationResponse> {
        public Builder tableName(String var1);

        public Builder kinesisDataStreamDestinations(Collection<KinesisDataStreamDestination> var1);

        public Builder kinesisDataStreamDestinations(KinesisDataStreamDestination ... var1);

        public Builder kinesisDataStreamDestinations(Consumer<KinesisDataStreamDestination.Builder> ... var1);
    }
}

