/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.translate;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.translate.AmazonTranslate;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.translate.TranslateConfiguration;
import org.apache.camel.component.aws.translate.TranslateEndpoint;
import org.apache.camel.component.aws.translate.TranslateOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(TranslateProducer.class);
    private transient String translateProducerToString;

    public TranslateProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case translateText: {
                this.translateText(this.getEndpoint().getTranslateClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private TranslateOperations determineOperation(Exchange exchange) {
        TranslateOperations operation = (TranslateOperations)((Object)exchange.getIn().getHeader("CamelAwsTranslateOperation", TranslateOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected TranslateConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.translateProducerToString == null) {
            this.translateProducerToString = "TranslateProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.translateProducerToString;
    }

    public TranslateEndpoint getEndpoint() {
        return (TranslateEndpoint)super.getEndpoint();
    }

    private void translateText(AmazonTranslate translateClient, Exchange exchange) {
        TranslateTextResult result;
        String target;
        String source;
        TranslateTextRequest request = new TranslateTextRequest();
        if (!this.getConfiguration().isAutodetectSourceLanguage()) {
            if (ObjectHelper.isEmpty((Object)this.getConfiguration().getSourceLanguage()) && ObjectHelper.isEmpty((Object)this.getConfiguration().getTargetLanguage())) {
                source = (String)exchange.getIn().getHeader("CamelAwsTranslateSourceLanguage", String.class);
                target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
                if (ObjectHelper.isEmpty((Object)source) || ObjectHelper.isEmpty((Object)target)) {
                    throw new IllegalArgumentException("Source and target language must be specified as headers or endpoint options");
                }
                request.setSourceLanguageCode(source);
                request.setTargetLanguageCode(target);
            } else {
                request.setSourceLanguageCode(this.getConfiguration().getSourceLanguage());
                request.setTargetLanguageCode(this.getConfiguration().getTargetLanguage());
            }
        } else {
            source = "auto";
            if (ObjectHelper.isEmpty((Object)this.getConfiguration().getTargetLanguage())) {
                target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
                if (ObjectHelper.isEmpty((Object)source) || ObjectHelper.isEmpty((Object)target)) {
                    throw new IllegalArgumentException("Target language must be specified when autodetection of source language is enabled");
                }
                request.setSourceLanguageCode(source);
                request.setTargetLanguageCode(target);
            } else {
                request.setSourceLanguageCode(source);
                request.setTargetLanguageCode(this.getConfiguration().getTargetLanguage());
            }
        }
        if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsTranslateTerminologyNames", Collection.class))) {
            Collection terminologies = (Collection)exchange.getIn().getHeader("CamelAwsTranslateTerminologyNames", Collection.class);
            request.setTerminologyNames(terminologies);
        }
        request.setText((String)exchange.getMessage().getBody(String.class));
        try {
            result = translateClient.translateText(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Translate Text command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = TranslateProducer.getMessageForResponse(exchange);
        message.setBody((Object)result.getTranslatedText());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

