/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.simpleworkflow.model.ResourceTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTagsForResourceOutput
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ResourceTag> tags;

    public List<ResourceTag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<ResourceTag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<ResourceTag>(tags);
    }

    public ListTagsForResourceOutput withTags(ResourceTag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<ResourceTag>(tags.length));
        }
        for (ResourceTag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ListTagsForResourceOutput withTags(Collection<ResourceTag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceOutput)) {
            return false;
        }
        ListTagsForResourceOutput other = (ListTagsForResourceOutput)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ListTagsForResourceOutput clone() {
        try {
            return (ListTagsForResourceOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

