/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.component.aws.swf.SwfComponentVerifierExtension;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;

@Component(value="aws-swf")
public class SWFComponent
extends DefaultComponent {
    @Metadata
    private SWFConfiguration configuration = new SWFConfiguration();

    public SWFComponent() {
        this(null);
    }

    public SWFComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SwfComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Map clientConfigurationParameters = PropertiesHelper.extractProperties(parameters, (String)"clientConfiguration.");
        Map sWClientParameters = PropertiesHelper.extractProperties(parameters, (String)"sWClient.");
        Map startWorkflowOptionsParameters = PropertiesHelper.extractProperties(parameters, (String)"startWorkflowOptions.");
        SWFConfiguration configuration = this.configuration != null ? this.configuration.copy() : new SWFConfiguration();
        configuration.setType(remaining);
        configuration.setClientConfigurationParameters(clientConfigurationParameters);
        configuration.setSWClientParameters(sWClientParameters);
        configuration.setStartWorkflowOptionsParameters(startWorkflowOptionsParameters);
        SWFEndpoint endpoint = new SWFEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonSWClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSWClient or accessKey and secretKey must be specified.");
        }
        return new SWFEndpoint(uri, this, configuration);
    }

    public SWFConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SWFConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(SWFConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonSimpleWorkflow.class);
        if (clients.size() == 1) {
            configuration.setAmazonSWClient((AmazonSimpleWorkflow)clients.stream().findFirst().get());
        }
    }
}

