/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="dataformat,transformation", title="Grok", firstVersion="3.0.0")
@XmlRootElement(name="grok")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GrokDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    @Metadata
    private String pattern;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String flattened;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String allowMultipleMatchesPerLine;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String namedOnly;

    public GrokDataFormat() {
        super("grok");
    }

    private GrokDataFormat(Builder builder) {
        this();
        this.pattern = builder.pattern;
        this.flattened = builder.flattened;
        this.allowMultipleMatchesPerLine = builder.allowMultipleMatchesPerLine;
        this.namedOnly = builder.namedOnly;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFlattened() {
        return this.flattened;
    }

    public void setFlattened(String flattened) {
        this.flattened = flattened;
    }

    public String getAllowMultipleMatchesPerLine() {
        return this.allowMultipleMatchesPerLine;
    }

    public void setAllowMultipleMatchesPerLine(String allowMultipleMatchesPerLine) {
        this.allowMultipleMatchesPerLine = allowMultipleMatchesPerLine;
    }

    public String getNamedOnly() {
        return this.namedOnly;
    }

    public void setNamedOnly(String namedOnly) {
        this.namedOnly = namedOnly;
    }

    public String toString() {
        return "GrokDataFormat[" + this.pattern + "]";
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<GrokDataFormat> {
        private String pattern;
        private String flattened;
        private String allowMultipleMatchesPerLine;
        private String namedOnly;

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder flattened(String flattened) {
            this.flattened = flattened;
            return this;
        }

        public Builder flattened(boolean flattened) {
            this.flattened = Boolean.toString(flattened);
            return this;
        }

        public Builder allowMultipleMatchesPerLine(String allowMultipleMatchesPerLine) {
            this.allowMultipleMatchesPerLine = allowMultipleMatchesPerLine;
            return this;
        }

        public Builder allowMultipleMatchesPerLine(boolean allowMultipleMatchesPerLine) {
            this.allowMultipleMatchesPerLine = Boolean.toString(allowMultipleMatchesPerLine);
            return this;
        }

        public Builder namedOnly(String namedOnly) {
            this.namedOnly = namedOnly;
            return this;
        }

        public Builder namedOnly(boolean namedOnly) {
            this.namedOnly = Boolean.toString(namedOnly);
            return this;
        }

        @Override
        public GrokDataFormat end() {
            return new GrokDataFormat(this);
        }
    }
}

