/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.sqs.NullMessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Component;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Constants;
import org.apache.camel.component.aws2.sqs.Sqs2Consumer;
import org.apache.camel.component.aws2.sqs.Sqs2HeaderFilterStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Producer;
import org.apache.camel.component.aws2.sqs.client.Sqs2ClientFactory;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SqsException;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-sqs", title="AWS Simple Queue Service (SQS)", syntax="aws2-sqs:queueNameOrArn", category={Category.CLOUD, Category.MESSAGING}, headersClass=Sqs2Constants.class)
public class Sqs2Endpoint
extends ScheduledPollEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Endpoint.class);
    private SqsClient client;
    private String queueUrl;
    @UriPath(description="Queue name or ARN")
    @Metadata(required=true)
    private String queueNameOrArn;
    @UriParam
    private Sqs2Configuration configuration;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public Sqs2Endpoint(String uri, Sqs2Component component, Sqs2Configuration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Producer createProducer() throws Exception {
        return new Sqs2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Sqs2Consumer consumer = new Sqs2Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return consumer;
    }

    private boolean isDefaultAwsHost() {
        return this.configuration.getAmazonAWSHost().equals("amazonaws.com");
    }

    private String getFullyQualifiedAWSHost() {
        String host = this.configuration.getAmazonAWSHost();
        host = FileUtil.stripTrailingSeparator((String)host);
        if (this.isDefaultAwsHost()) {
            return "sqs." + Region.of((String)this.configuration.getRegion()).id() + "." + host;
        }
        return host;
    }

    private String getAwsEndpointUri() {
        return this.configuration.getProtocol() + "://" + this.getFullyQualifiedAWSHost();
    }

    protected void doInit() throws Exception {
        super.doInit();
        SqsClient sqsClient = this.client = this.configuration.getAmazonSQSClient() != null ? this.configuration.getAmazonSQSClient() : Sqs2ClientFactory.getSqsClient(this.configuration).getSQSClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new Sqs2HeaderFilterStrategy();
        }
        if (this.configuration.getQueueUrl() != null) {
            this.queueUrl = this.configuration.getQueueUrl();
        } else if (this.configuration.getRegion() != null && this.configuration.getQueueOwnerAWSAccountId() != null) {
            this.queueUrl = this.getAwsEndpointUri() + "/" + this.configuration.getQueueOwnerAWSAccountId() + "/" + this.configuration.getQueueName();
        } else if (this.configuration.getQueueOwnerAWSAccountId() != null) {
            GetQueueUrlRequest.Builder getQueueUrlRequest = GetQueueUrlRequest.builder();
            getQueueUrlRequest.queueName(this.configuration.getQueueName());
            getQueueUrlRequest.queueOwnerAWSAccountId(this.configuration.getQueueOwnerAWSAccountId());
            GetQueueUrlResponse getQueueUrlResult = this.client.getQueueUrl((GetQueueUrlRequest)getQueueUrlRequest.build());
            this.queueUrl = getQueueUrlResult.queueUrl();
        } else {
            String queueNamePath = "/" + this.configuration.getQueueName();
            ListQueuesRequest.Builder listQueuesRequestBuilder = ListQueuesRequest.builder().maxResults(Integer.valueOf(1000)).queueNamePrefix(this.configuration.getQueueName());
            while (true) {
                String token;
                ListQueuesResponse listQueuesResult = this.client.listQueues((ListQueuesRequest)listQueuesRequestBuilder.build());
                for (String url : listQueuesResult.queueUrls()) {
                    if (!url.endsWith(queueNamePath)) continue;
                    this.queueUrl = url;
                    LOG.trace("Queue available at '{}'.", (Object)this.queueUrl);
                    break;
                }
                if (this.queueUrl != null || (token = listQueuesResult.nextToken()) == null) break;
                listQueuesRequestBuilder = listQueuesRequestBuilder.nextToken(token);
            }
        }
        if (this.queueUrl == null && this.configuration.isAutoCreateQueue()) {
            this.createQueue(this.client);
        } else {
            LOG.debug("Using Amazon SQS queue url: {}", (Object)this.queueUrl);
            this.updateQueueAttributes(this.client);
        }
    }

    private boolean queueExists(SqsClient client) {
        LOG.trace("Checking if queue '{}' exists", (Object)this.configuration.getQueueName());
        GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(this.configuration.getQueueName()).build();
        try {
            this.queueUrl = client.getQueueUrl(getQueueUrlRequest).queueUrl();
            LOG.trace("Queue '{}' exists and its URL is '{}'", (Object)this.configuration.getQueueName(), (Object)this.queueUrl);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            LOG.trace("Queue '{}' does not exist", (Object)this.configuration.getQueueName());
            return false;
        }
    }

    protected void createQueue(SqsClient client) throws IOException {
        if (this.queueExists(client)) {
            return;
        }
        LOG.trace("Creating the a queue named '{}'", (Object)this.configuration.getQueueName());
        CreateQueueRequest.Builder request = CreateQueueRequest.builder().queueName(this.configuration.getQueueName());
        HashMap<QueueAttributeName, String> attributes = new HashMap<QueueAttributeName, String>();
        if (this.getConfiguration().isFifoQueue()) {
            attributes.put(QueueAttributeName.FIFO_QUEUE, String.valueOf(true));
            boolean useContentBasedDeduplication = this.getConfiguration().getMessageDeduplicationIdStrategy() instanceof NullMessageDeduplicationIdStrategy;
            attributes.put(QueueAttributeName.CONTENT_BASED_DEDUPLICATION, String.valueOf(useContentBasedDeduplication));
        }
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            attributes.put(QueueAttributeName.VISIBILITY_TIMEOUT, String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            attributes.put(QueueAttributeName.MAXIMUM_MESSAGE_SIZE, String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            attributes.put(QueueAttributeName.MESSAGE_RETENTION_PERIOD, String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            InputStream s = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getConfiguration().getPolicy());
            String policy = IOUtils.toString((InputStream)s, (Charset)Charset.defaultCharset());
            attributes.put(QueueAttributeName.POLICY, policy);
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            attributes.put(QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS, String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getDelaySeconds() != null && this.getConfiguration().isDelayQueue()) {
            attributes.put(QueueAttributeName.DELAY_SECONDS, String.valueOf(this.getConfiguration().getDelaySeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            attributes.put(QueueAttributeName.REDRIVE_POLICY, this.getConfiguration().getRedrivePolicy());
        }
        if (this.getConfiguration().isServerSideEncryptionEnabled()) {
            if (this.getConfiguration().getKmsMasterKeyId() != null) {
                attributes.put(QueueAttributeName.KMS_MASTER_KEY_ID, this.getConfiguration().getKmsMasterKeyId());
            }
            if (this.getConfiguration().getKmsDataKeyReusePeriodSeconds() != null) {
                attributes.put(QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS, String.valueOf(this.getConfiguration().getKmsDataKeyReusePeriodSeconds()));
            }
        }
        LOG.trace("Trying to create queue [{}] with request [{}]...", (Object)this.configuration.getQueueName(), (Object)request);
        request.attributes(attributes);
        try {
            CreateQueueResponse queueResult = client.createQueue((CreateQueueRequest)request.build());
            this.queueUrl = queueResult.queueUrl();
        }
        catch (SqsException e) {
            if (this.queueExists(client)) {
                LOG.warn("The queue may have been created since last check and could not be created");
                LOG.debug("AWS SDK error preventing queue creation: {}", (Object)e.getMessage(), (Object)e);
            }
            throw e;
        }
        LOG.trace("Queue created and available at: {}", (Object)this.queueUrl);
    }

    private void updateQueueAttributes(SqsClient client) throws IOException {
        SetQueueAttributesRequest.Builder request = SetQueueAttributesRequest.builder().queueUrl(this.queueUrl);
        HashMap<QueueAttributeName, String> attributes = new HashMap<QueueAttributeName, String>();
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            attributes.put(QueueAttributeName.VISIBILITY_TIMEOUT, String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            attributes.put(QueueAttributeName.MAXIMUM_MESSAGE_SIZE, String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            attributes.put(QueueAttributeName.MESSAGE_RETENTION_PERIOD, String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            InputStream s = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getConfiguration().getPolicy());
            String policy = IOUtils.toString((InputStream)s, (Charset)Charset.defaultCharset());
            attributes.put(QueueAttributeName.POLICY, policy);
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            attributes.put(QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS, String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getDelaySeconds() != null && this.getConfiguration().isDelayQueue()) {
            attributes.put(QueueAttributeName.DELAY_SECONDS, String.valueOf(this.getConfiguration().getDelaySeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            attributes.put(QueueAttributeName.REDRIVE_POLICY, this.getConfiguration().getRedrivePolicy());
        }
        if (this.getConfiguration().isServerSideEncryptionEnabled()) {
            if (this.getConfiguration().getKmsMasterKeyId() != null) {
                attributes.put(QueueAttributeName.KMS_MASTER_KEY_ID, this.getConfiguration().getKmsMasterKeyId());
            }
            if (this.getConfiguration().getKmsDataKeyReusePeriodSeconds() != null) {
                attributes.put(QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS, String.valueOf(this.getConfiguration().getKmsDataKeyReusePeriodSeconds()));
            }
        }
        if (!attributes.isEmpty()) {
            request.attributes(attributes);
            LOG.trace("Updating queue '{}' with the provided queue attributes...", (Object)this.configuration.getQueueName());
            client.setQueueAttributes((SetQueueAttributesRequest)request.build());
            LOG.trace("Queue '{}' updated and available at {}'", (Object)this.configuration.getQueueName(), (Object)this.queueUrl);
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSQSClient()) && this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    public Sqs2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sqs2Configuration configuration) {
        this.configuration = configuration;
    }

    public SqsClient getClient() {
        return this.client;
    }

    public void setClient(SqsClient client) {
        this.client = client;
    }

    protected String getQueueUrl() {
        return this.queueUrl;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

