/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.Map;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Consumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class Sqs2ConsumerHealthCheck
extends AbstractHealthCheck {
    private final Sqs2Consumer sqs2Consumer;
    private final String routeId;

    public Sqs2ConsumerHealthCheck(Sqs2Consumer sqs2Consumer, String routeId) {
        super("camel", "aws2-sqs-consumer-" + routeId);
        this.sqs2Consumer = sqs2Consumer;
        this.routeId = routeId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            SqsClient client;
            Sqs2Configuration configuration = this.sqs2Consumer.getConfiguration();
            if (!SqsClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            if (!configuration.isUseDefaultCredentialsProvider()) {
                AwsBasicCredentials cred = AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey());
                SqsClientBuilder clientBuilder = SqsClient.builder();
                client = (SqsClient)((SqsClientBuilder)((SqsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred))).region(Region.of((String)configuration.getRegion()))).build();
            } else if (ObjectHelper.isNotEmpty((Object)configuration.getAmazonSQSClient())) {
                client = configuration.getAmazonSQSClient();
            } else {
                SqsClientBuilder clientBuilder = SqsClient.builder();
                client = (SqsClient)((SqsClientBuilder)clientBuilder.region(Region.of((String)configuration.getRegion()))).build();
            }
            client.listQueues();
        }
        catch (SdkClientException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

