/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

@Component(value="aws2-sqs")
public class Sqs2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Component.class);
    @Metadata
    private Sqs2Configuration configuration = new Sqs2Configuration();

    public Sqs2Component() {
        this(null);
    }

    public Sqs2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Sqs2Configuration configuration;
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Queue name must be specified.");
        }
        Sqs2Configuration sqs2Configuration = configuration = this.configuration != null ? this.configuration.copy() : new Sqs2Configuration();
        if (remaining.startsWith("arn:")) {
            String[] parts = remaining.split(":");
            if (parts.length != 6 || !parts[2].equals("sqs")) {
                throw new IllegalArgumentException("Queue arn must be in format arn:aws:sqs:region:account:name.");
            }
            configuration.setRegion(Region.of((String)parts[3]).toString());
            configuration.setQueueOwnerAWSAccountId(parts[4]);
            configuration.setQueueName(parts[5]);
        } else {
            configuration.setQueueName(remaining);
        }
        Sqs2Endpoint sqsEndpoint = new Sqs2Endpoint(uri, this, configuration);
        this.setProperties((Endpoint)sqsEndpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider() || configuration.getAmazonSQSClient() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("AmazonSQSClient or accessKey and secretKey must be specified.");
        }
        if (configuration.isExtendMessageVisibility() && configuration.getVisibilityTimeout() == null) {
            throw new IllegalArgumentException("Extending message visibility (extendMessageVisibility) requires visibilityTimeout to be set on the Endpoint.");
        }
        return sqsEndpoint;
    }

    public Sqs2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sqs2Configuration configuration) {
        this.configuration = configuration;
    }
}

