/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.NamedNode;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;

public final class ProcessorDefinitionHelper {
    private ProcessorDefinitionHelper() {
    }

    public static <T> Collection<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        return ProcessorDefinitionHelper.filterTypeInOutputs(outputs, type, -1);
    }

    public static <T> Collection<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type, int maxDeep) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found, maxDeep);
        return found;
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found, -1);
        if (found.isEmpty()) {
            return null;
        }
        return (T)found.iterator().next();
    }

    public static boolean isFirstChildOfType(Class<?> parentType, ProcessorDefinition<?> node) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (node.getParent().getOutputs().isEmpty()) {
            return false;
        }
        if (!node.getParent().getClass().equals(parentType)) {
            return false;
        }
        return node.getParent().getOutputs().get(0).equals(node);
    }

    public static boolean isParentOfType(Class<? extends ProcessorDefinition> parentType, ProcessorDefinition<?> node, boolean recursive) {
        return ProcessorDefinitionHelper.findFirstParentOfType(parentType, node, recursive) != null;
    }

    public static <T extends ProcessorDefinition> T findFirstParentOfType(Class<T> parentType, ProcessorDefinition<?> node, boolean recursive) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        if (parentType.isAssignableFrom(node.getParent().getClass())) {
            return (T)((ProcessorDefinition)parentType.cast(node.getParent()));
        }
        if (recursive) {
            return ProcessorDefinitionHelper.findFirstParentOfType(parentType, node.getParent(), true);
        }
        return null;
    }

    public static RouteDefinition getRoute(NamedNode node) {
        ProcessorDefinition def;
        if (node == null) {
            return null;
        }
        for (def = (ProcessorDefinition)node; def != null && def.getParent() != null; def = def.getParent()) {
        }
        if (def instanceof RouteDefinition) {
            return (RouteDefinition)def;
        }
        return null;
    }

    public static String getRouteId(NamedNode node) {
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(node);
        return route != null ? route.getId() : null;
    }

    public static Set<String> gatherAllNodeIds(ProcessorDefinition<?> node, Set<String> set, boolean onlyCustomId, boolean includeAbstract) {
        List<ProcessorDefinition<?>> children;
        if (node == null) {
            return set;
        }
        if (node.isAbstract() && !includeAbstract) {
            return set;
        }
        if (set == null) {
            set = new LinkedHashSet<String>();
        }
        if (node.getId() != null && (!onlyCustomId || node.hasCustomIdAssigned() && onlyCustomId)) {
            set.add(node.getId());
        }
        if ((children = node.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                ProcessorDefinitionHelper.gatherAllNodeIds(child, set, onlyCustomId, includeAbstract);
            }
        }
        return set;
    }

    public static void resetAllAutoAssignedNodeIds(ProcessorDefinition<?> node) {
        List<ProcessorDefinition<?>> children;
        if (node == null) {
            return;
        }
        if (node.isAbstract()) {
            return;
        }
        if (node.getId() != null && !node.hasCustomIdAssigned()) {
            node.setId(null);
        }
        if ((children = node.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                ProcessorDefinitionHelper.resetAllAutoAssignedNodeIds(child);
            }
        }
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found, int maxDeep) {
        if (maxDeep > 0) {
            for (ProcessorDefinition<?> out : outputs) {
                if (!out.isAbstract() || !out.isTopLevelOnly()) continue;
                ++maxDeep;
                break;
            }
        }
        ProcessorDefinitionHelper.doFindType(outputs, type, found, 1, maxDeep);
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found, int current, int maxDeep) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        if (maxDeep > 0 && current > maxDeep) {
            return;
        }
        for (ProcessorDefinition<?> out : outputs) {
            List<ProcessorDefinition<?>> children;
            if (out instanceof SendDefinition) {
                SendDefinition send = (SendDefinition)out;
                children = send.getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found, ++current, maxDeep);
            }
            if (out instanceof ChoiceDefinition) {
                ChoiceDefinition choice = (ChoiceDefinition)out;
                if (type.isInstance(choice)) {
                    found.add(choice);
                }
                if (maxDeep >= 0 && current >= maxDeep) continue;
                for (WhenDefinition when : choice.getWhenClauses()) {
                    if (type.isInstance(when)) {
                        found.add(when);
                    }
                    List<ProcessorDefinition<?>> children2 = when.getOutputs();
                    ProcessorDefinitionHelper.doFindType(children2, type, found, ++current, maxDeep);
                }
                if (choice.getOtherwise() == null) continue;
                children = choice.getOtherwise().getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found, ++current, maxDeep);
                continue;
            }
            if (out instanceof TryDefinition) {
                TryDefinition doTry = (TryDefinition)out;
                if (type.isInstance(doTry)) {
                    found.add(doTry);
                }
                if (maxDeep >= 0 && current >= maxDeep) continue;
                List<ProcessorDefinition<?>> doTryOut = doTry.getOutputsWithoutCatches();
                ProcessorDefinitionHelper.doFindType(doTryOut, type, found, ++current, maxDeep);
                List<CatchDefinition> doTryCatch = doTry.getCatchClauses();
                for (CatchDefinition doCatch : doTryCatch) {
                    ProcessorDefinitionHelper.doFindType(doCatch.getOutputs(), type, found, ++current, maxDeep);
                }
                if (doTry.getFinallyClause() == null) continue;
                ProcessorDefinitionHelper.doFindType(doTry.getFinallyClause().getOutputs(), type, found, ++current, maxDeep);
                continue;
            }
            if (out instanceof OutputDefinition) {
                OutputDefinition outDef = (OutputDefinition)out;
                if (type.isInstance(outDef)) {
                    found.add(outDef);
                }
                List<ProcessorDefinition<?>> outDefOut = outDef.getOutputs();
                ProcessorDefinitionHelper.doFindType(outDefOut, type, found, ++current, maxDeep);
                continue;
            }
            if (type.isInstance(out)) {
                found.add(out);
            }
            List<ProcessorDefinition<?>> children3 = out.getOutputs();
            ProcessorDefinitionHelper.doFindType(children3, type, found, ++current, maxDeep);
        }
    }

    public static void prepareSourceLocation(Resource resource, NamedNode node) {
        int number;
        if (resource != null) {
            node.setLocation(resource.getLocation());
            String ext = FileUtil.onlyExt((String)resource.getLocation(), (boolean)true);
            if ("groovy".equals(ext) || "js".equals(ext) || "jsh".equals(ext)) {
                return;
            }
        }
        if ((number = node.getLineNumber()) < 0) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            for (int i = 1; i < st.length; ++i) {
                StackTraceElement e = st[i];
                if (e.getClassName().startsWith("org.apache.camel.model") || e.getClassName().startsWith("org.apache.camel.builder.RouteBuilder") || e.getClassName().startsWith("org.apache.camel.dsl")) continue;
                node.setLineNumber(e.getLineNumber());
                if (node.getLocation() == null) {
                    String scheme;
                    Object name = e.getFileName();
                    if (name == null) {
                        name = e.getClassName();
                    }
                    if (!ResourceHelper.hasScheme((String)name) && (scheme = ProcessorDefinitionHelper.findParentSourceLocationScheme(node)) != null) {
                        name = scheme + (String)name;
                    }
                    node.setLocation((String)name);
                }
                return;
            }
        }
    }

    public static int getNodeLevel(NamedNode node) {
        int level = 0;
        while (node != null && node.getParent() != null) {
            boolean shallow = node instanceof WhenDefinition || node instanceof OtherwiseDefinition;
            node = node.getParent();
            if (shallow) continue;
            ++level;
        }
        return level;
    }

    public static String findParentSourceLocationScheme(NamedNode node) {
        while (node != null && node.getParent() != null) {
            String location = node.getLocation();
            if (ResourceHelper.hasScheme((String)location)) {
                return ResourceHelper.getScheme((String)location);
            }
            node = node.getParent();
        }
        return null;
    }
}

