/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.sqs.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sqs.MessageGroupIdStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Endpoint;
import org.apache.camel.component.aws2.sqs.Sqs2Operations;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class Sqs2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Producer.class);
    private static final int MAX_ATTRIBUTES = 10;
    private transient String sqsProducerToString;

    public Sqs2Producer(Sqs2Endpoint endpoint) {
        super((Endpoint)endpoint);
        if (endpoint.getConfiguration().isFifoQueue() && ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
            throw new IllegalArgumentException("messageGroupIdStrategy must be set for FIFO queues.");
        }
    }

    public void process(Exchange exchange) throws Exception {
        Sqs2Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            this.processSingleMessage(exchange);
        } else {
            switch (operation) {
                case sendBatchMessage: {
                    this.sendBatchMessage(this.getClient(), exchange);
                    break;
                }
                case deleteMessage: {
                    this.deleteMessage(this.getClient(), exchange);
                    break;
                }
                case listQueues: {
                    this.listQueues(this.getClient(), exchange);
                    break;
                }
                case purgeQueue: {
                    this.purgeQueue(this.getClient(), exchange);
                    break;
                }
                case deleteQueue: {
                    this.deleteQueue(this.getClient(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processSingleMessage(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        SendMessageRequest.Builder request = SendMessageRequest.builder().queueUrl(this.getQueueUrl()).messageBody(body);
        request.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.addDelay(request, exchange);
        this.configureFifoAttributes(request, exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendMessageResponse result = this.getClient().sendMessage((SendMessageRequest)request.build());
        LOG.trace("Received result [{}]", (Object)result);
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSqsMessageId", (Object)result.messageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)result.md5OfMessageBody());
    }

    private void sendBatchMessage(SqsClient amazonSQS, Exchange exchange) {
        SendMessageBatchRequest.Builder request = SendMessageBatchRequest.builder().queueUrl(this.getQueueUrl());
        ArrayList<Object> entries = new ArrayList<Object>();
        if (exchange.getIn().getBody() instanceof Iterable) {
            Iterable c = (Iterable)exchange.getIn().getBody(Iterable.class);
            for (Object o : c) {
                String object = (String)o;
                SendMessageBatchRequestEntry.Builder entry = SendMessageBatchRequestEntry.builder();
                entry.id(UUID.randomUUID().toString());
                entry.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
                entry.messageBody(object);
                this.addDelay(entry, exchange);
                this.configureFifoAttributes(entry, exchange);
                entries.add(entry.build());
            }
            request.entries(entries);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch((SendMessageBatchRequest)request.build());
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof String) {
            String[] elements;
            String c = (String)exchange.getIn().getBody(String.class);
            for (String o : elements = c.split(this.getConfiguration().getBatchSeparator())) {
                SendMessageBatchRequestEntry.Builder entry = SendMessageBatchRequestEntry.builder();
                entry.id(UUID.randomUUID().toString());
                entry.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
                entry.messageBody(o);
                this.addDelay(entry, exchange);
                this.configureFifoAttributes(entry, exchange);
                entries.add(entry.build());
            }
            request.entries(entries);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch((SendMessageBatchRequest)request.build());
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else {
            SendMessageBatchRequest req = (SendMessageBatchRequest)exchange.getIn().getBody(SendMessageBatchRequest.class);
            SendMessageBatchResponse result = amazonSQS.sendMessageBatch(req);
            Message message = Sqs2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteMessage(SqsClient amazonSQS, Exchange exchange) {
        String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
        DeleteMessageRequest.Builder request = DeleteMessageRequest.builder();
        request.queueUrl(this.getQueueUrl());
        if (ObjectHelper.isEmpty((Object)receiptHandle)) {
            throw new IllegalArgumentException("Receipt Handle must be specified for the operation deleteMessage");
        }
        request.receiptHandle(receiptHandle);
        DeleteMessageResponse result = amazonSQS.deleteMessage((DeleteMessageRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listQueues(SqsClient amazonSQS, Exchange exchange) {
        ListQueuesRequest.Builder request = ListQueuesRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSqsPrefix"))) {
            request.queueNamePrefix((String)exchange.getIn().getHeader("CamelAwsSqsPrefix", String.class));
        }
        ListQueuesResponse result = amazonSQS.listQueues((ListQueuesRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void purgeQueue(SqsClient amazonSQS, Exchange exchange) {
        PurgeQueueRequest.Builder request = PurgeQueueRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSqsPrefix"))) {
            request.queueUrl(this.getQueueUrl());
        }
        PurgeQueueResponse result = amazonSQS.purgeQueue((PurgeQueueRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteQueue(SqsClient amazonSQS, Exchange exchange) {
        DeleteQueueRequest.Builder request = DeleteQueueRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSqsPrefix"))) {
            request.queueUrl(this.getQueueUrl());
        }
        DeleteQueueResponse result = amazonSQS.deleteQueue((DeleteQueueRequest)request.build());
        Message message = Sqs2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void configureFifoAttributes(SendMessageRequest.Builder request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
                MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
                String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
                request.messageGroupId(messageGroupId);
            }
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy())) {
                MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
                String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
                request.messageDeduplicationId(messageDeduplicationId);
            }
        }
    }

    private void configureFifoAttributes(SendMessageBatchRequestEntry.Builder request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoQueue()) {
            MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
            String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
            request.messageGroupId(messageGroupId);
            MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
            String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
            request.messageDeduplicationId(messageDeduplicationId);
        }
    }

    private void addDelay(SendMessageRequest.Builder request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (headerValue == null) {
            LOG.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            LOG.trace("Using the header delay");
            delayValue = headerValue;
        }
        LOG.trace("found delay: {}", (Object)delayValue);
        if (delayValue != null) {
            request.delaySeconds(delayValue);
        }
    }

    private void addDelay(SendMessageBatchRequestEntry.Builder request, Exchange exchange) {
        Integer delayValue;
        Integer headerValue = (Integer)exchange.getIn().getHeader("CamelAwsSqsDelaySeconds", Integer.class);
        if (headerValue == null) {
            LOG.trace("Using the config delay");
            delayValue = this.getEndpoint().getConfiguration().getDelaySeconds();
        } else {
            LOG.trace("Using the header delay");
            delayValue = headerValue;
        }
        LOG.trace("found delay: {}", (Object)delayValue);
        if (delayValue != null) {
            request.delaySeconds(delayValue);
        }
    }

    protected SqsClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    protected Sqs2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Sqs2Endpoint getEndpoint() {
        return (Sqs2Endpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.sqsProducerToString == null) {
            this.sqsProducerToString = "SqsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsProducerToString;
    }

    Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            MessageAttributeValue.Builder mav;
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange) || result.size() >= 10) continue;
            Object value = entry.getValue();
            if (value instanceof String && !((String)value).isEmpty()) {
                mav = MessageAttributeValue.builder();
                mav.dataType("String");
                mav.stringValue((String)value);
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof ByteBuffer) {
                mav = MessageAttributeValue.builder();
                mav.dataType("Binary");
                mav.binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)((ByteBuffer)value)));
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof Boolean) {
                mav = MessageAttributeValue.builder();
                mav.dataType("Number.Boolean");
                mav.stringValue((Boolean)value != false ? "1" : "0");
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof Number) {
                mav = MessageAttributeValue.builder();
                String dataType = value instanceof Integer ? "Number.int" : (value instanceof Byte ? "Number.byte" : (value instanceof Double ? "Number.double" : (value instanceof Float ? "Number.float" : (value instanceof Long ? "Number.long" : (value instanceof Short ? "Number.short" : "Number")))));
                mav.dataType(dataType);
                mav.stringValue(value.toString());
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof Date) {
                mav = MessageAttributeValue.builder();
                mav.dataType("String");
                mav.stringValue(value.toString());
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            LOG.warn("Cannot put the message header key={}, value={} into Sqs MessageAttribute", (Object)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private Sqs2Operations determineOperation(Exchange exchange) {
        Sqs2Operations operation = (Sqs2Operations)((Object)exchange.getIn().getHeader("CamelAwsSqsOperation", Sqs2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

