/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.format.AbstractRFC3986Format;
import com.networknt.schema.format.IPv6Format;
import java.net.URI;

public class IriFormat
extends AbstractRFC3986Format {
    @Override
    protected boolean validate(URI uri) {
        boolean result = uri.isAbsolute();
        if (result) {
            String authority = uri.getAuthority();
            if (authority != null && IPv6Format.PATTERN.matcher(authority).matches()) {
                return false;
            }
            String query = uri.getQuery();
            if (query != null && (query.indexOf(91) != -1 || query.indexOf(93) != -1)) {
                return false;
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "iri";
    }

    @Override
    public String getMessageKey() {
        return "format.iri";
    }
}

