/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class XMLStreamReaderInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 4096;
    private final XMLStreamReader reader;
    private XMLStreamWriter writer;
    private final TrimmableByteArrayOutputStream chunk;
    private final byte[] buffer;
    private final String charset;
    private int bpos;

    XMLStreamReaderInputStream(XMLStreamReader reader, String charset, XMLOutputFactory outfactory) {
        this.reader = reader;
        this.buffer = new byte[4096];
        this.chunk = new TrimmableByteArrayOutputStream();
        this.charset = charset == null ? "utf-8" : charset;
        try {
            this.writer = outfactory.createXMLStreamWriter(this.chunk, this.charset);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    XMLStreamReaderInputStream(XMLStreamReader reader, XMLOutputFactory outfactory) {
        this(reader, "utf-8", outfactory);
    }

    @Override
    public int read() throws IOException {
        byte[] ba = new byte[1];
        return this.read(ba, 0, 1) == 1 ? ba[0] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        int tlen = 0;
        while (len > 0 && (n = this.ensureBuffering(len)) >= 0) {
            int clen = len > n ? n : len;
            System.arraycopy(this.buffer, 0, b, off, clen);
            System.arraycopy(this.buffer, clen, this.buffer, 0, this.buffer.length - clen);
            this.bpos -= clen;
            len -= clen;
            off += clen;
            tlen += clen;
        }
        return tlen > 0 ? tlen : -1;
    }

    private int ensureBuffering(int size) throws IOException {
        if (size < this.bpos) {
            return this.bpos;
        }
        try {
            int csize;
            if (7 == this.reader.getEventType()) {
                this.writer.writeStartDocument(this.charset, "1.0");
            }
            if (this.chunk.size() < this.buffer.length) {
                while (this.reader.hasNext()) {
                    int code = this.reader.next();
                    switch (code) {
                        case 8: {
                            this.writer.writeEndDocument();
                            break;
                        }
                        case 1: {
                            int i;
                            QName qname = this.reader.getName();
                            this.writer.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                            for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                                String namespaceUri = this.reader.getAttributeNamespace(i);
                                this.writer.writeAttribute(this.reader.getAttributePrefix(i), namespaceUri == null ? "" : namespaceUri, this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                            }
                            for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                                String namespacePrefix = this.reader.getNamespacePrefix(i);
                                String namespaceURI = this.reader.getNamespaceURI(i);
                                this.writer.writeNamespace(namespacePrefix == null ? "" : namespacePrefix, namespaceURI == null ? "" : namespaceURI);
                            }
                            break;
                        }
                        case 2: {
                            this.writer.writeEndElement();
                            break;
                        }
                        case 4: {
                            this.writer.writeCharacters(this.reader.getText());
                            break;
                        }
                        case 5: {
                            this.writer.writeComment(this.reader.getText());
                            break;
                        }
                        case 12: {
                            this.writer.writeCData(this.reader.getText());
                            break;
                        }
                    }
                    int csize2 = this.buffer.length - this.bpos;
                    if (this.chunk.size() <= csize2) continue;
                    System.arraycopy(this.chunk.getByteArray(), 0, this.buffer, this.bpos, csize2);
                    this.bpos = this.buffer.length;
                    this.chunk.trim(csize2, 0);
                    return this.buffer.length;
                }
            }
            int n = csize = this.chunk.size() < this.buffer.length - this.bpos ? this.chunk.size() : this.buffer.length - this.bpos;
            if (csize > 0) {
                System.arraycopy(this.chunk.getByteArray(), 0, this.buffer, this.bpos, csize);
                this.bpos += csize;
                this.chunk.trim(csize, 0);
                return this.bpos;
            }
            return this.bpos > 0 ? this.bpos : -1;
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    static class TrimmableByteArrayOutputStream
    extends ByteArrayOutputStream {
        TrimmableByteArrayOutputStream() {
        }

        public void trim(int head, int tail) {
            System.arraycopy(this.buf, head, this.buf, 0, this.count - head - tail);
            this.count -= head + tail;
        }

        public byte[] toByteArray(int len) {
            byte[] b = new byte[len];
            System.arraycopy(this.buf, 0, b, 0, len);
            return b;
        }

        byte[] getByteArray() {
            return this.buf;
        }
    }
}

