/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import io.apicurio.registry.utils.converter.avro.AvroData;
import io.apicurio.registry.utils.converter.avro.AvroDataConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkPojoToSchemaAndStructTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String CAMEL_TRANSFORMER_SINK_POJO_CLASS_PROPERTY = "camel.transformer.sink.pojo.class";
    private static final Logger LOG = LoggerFactory.getLogger(SinkPojoToSchemaAndStructTransform.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new AvroFactory());
    private static final String CAMEL_TRANSFORMER_SINK_POJO_CLASS_DOC = "Full qualified class name of the pojo you want your record value converted to";
    private static final Object CAMEL_TRANSFORMER_SINK_POJO_CLASS_DEFAULT = ConfigDef.NO_DEFAULT_VALUE;
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("camel.transformer.sink.pojo.class", ConfigDef.Type.STRING, CAMEL_TRANSFORMER_SINK_POJO_CLASS_DEFAULT, ConfigDef.Importance.HIGH, "Full qualified class name of the pojo you want your record value converted to");
    private String pojoClass;
    private ObjectReader objectReader;
    private AvroData avroData;

    public R apply(R r) {
        LOG.debug("Incoming record: {}", r);
        if (r.value() != null && r.valueSchema() != null && Schema.Type.STRUCT.equals((Object)r.valueSchema().type())) {
            Object pojo;
            GenericRecord avroGenericRecord = (GenericRecord)this.avroData.fromConnectData(r.valueSchema(), r.value());
            if (avroGenericRecord == null) {
                LOG.warn("No GenericRecord was converted as part of this transformation");
                return r;
            }
            LOG.debug("GenericRecord created: {} \nwith schema: {}", (Object)avroGenericRecord, (Object)avroGenericRecord.getClass().getName());
            GenericDatumWriter writer = new GenericDatumWriter(avroGenericRecord.getSchema());
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
                writer.write((Object)avroGenericRecord, (Encoder)encoder);
                encoder.flush();
                byte[] avroDataBytes = out.toByteArray();
                pojo = this.objectReader.with((FormatSchema)new AvroSchema(avroGenericRecord.getSchema())).readValue(avroDataBytes);
                LOG.debug("Pojo of class {} created: {}", pojo.getClass(), pojo);
            }
            catch (IOException e) {
                throw new ConnectException("Error in generating POJO from Struct.", (Throwable)e);
            }
            LOG.debug("Generate pojo: {}", pojo);
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), r.keySchema(), r.key(), null, pojo, r.timestamp());
        }
        LOG.debug("Incoming record with a null value or a value schema != Schema.Type.STRUCT, nothing to be done.");
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, configs);
        this.pojoClass = config.getString(CAMEL_TRANSFORMER_SINK_POJO_CLASS_PROPERTY);
        this.avroData = new AvroData(new AvroDataConfig(configs));
        try {
            this.objectReader = MAPPER.readerFor(Class.forName(this.pojoClass));
        }
        catch (ClassNotFoundException e) {
            throw new ConnectException("Unable to initialize SinkPojoToSchemaAndStructTransform ", (Throwable)e);
        }
    }
}

