/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.utils.IoUtil;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

public class AvroSerdeHeaders {
    private final String encodingHeaderName;

    public AvroSerdeHeaders(boolean isKey) {
        this.encodingHeaderName = isKey ? "apicurio.key.encoding" : "apicurio.value.encoding";
    }

    public void addEncodingHeader(Headers headers, String encoding) {
        headers.add((Header)new RecordHeader(this.encodingHeaderName, encoding.getBytes()));
    }

    public String getEncoding(Headers headers) {
        Header encodingHeader = headers.lastHeader(this.encodingHeaderName);
        if (encodingHeader != null) {
            return IoUtil.toString((byte[])encodingHeader.value());
        }
        return null;
    }
}

