/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.AdviceIterator;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.SharedInternalProcessor;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCamelInternalProcessor
implements SharedInternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedCamelInternalProcessor.class);
    private static final Object[] EMPTY_STATES = new Object[0];
    private final ReactiveExecutor reactiveExecutor;
    private final AsyncProcessorAwaitManager awaitManager;
    private final ShutdownStrategy shutdownStrategy;
    private final List<CamelInternalProcessorAdvice<?>> advices;
    private byte statefulAdvices;

    public SharedCamelInternalProcessor(CamelContext camelContext, CamelInternalProcessorAdvice<?> ... advices) {
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.awaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)camelContext);
        this.shutdownStrategy = camelContext.getShutdownStrategy();
        if (advices != null) {
            this.advices = new ArrayList(advices.length);
            for (CamelInternalProcessorAdvice<?> advice : advices) {
                this.advices.add(advice);
                if (!advice.hasState()) continue;
                this.statefulAdvices = (byte)(this.statefulAdvices + 1);
            }
            this.advices.sort((Comparator<CamelInternalProcessorAdvice<?>>)OrderedComparator.get());
        } else {
            this.advices = null;
        }
    }

    public void process(Exchange exchange, final AsyncProcessor processor, final Processor resultProcessor) {
        this.awaitManager.process(new AsyncProcessor(){

            public boolean process(Exchange exchange, AsyncCallback callback) {
                return SharedCamelInternalProcessor.this.process(exchange, callback, processor, resultProcessor);
            }

            public CompletableFuture<Exchange> processAsync(Exchange exchange) {
                AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
                this.process(exchange, (AsyncCallback)callback);
                return callback.getFuture();
            }

            public void process(Exchange exchange) throws Exception {
                throw new IllegalStateException();
            }
        }, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback originalCallback, AsyncProcessor processor, Processor resultProcessor) {
        if (processor == null || !this.continueProcessing(exchange, processor)) {
            originalCallback.done(true);
            return true;
        }
        Object[] states = this.statefulAdvices > 0 ? new Object[this.statefulAdvices] : EMPTY_STATES;
        int j = 0;
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice<?> task = this.advices.get(i);
            try {
                Object state = task.before(exchange);
                if (!task.hasState()) continue;
                states[j++] = state;
                continue;
            }
            catch (Exception e) {
                return SharedCamelInternalProcessor.handleException(exchange, originalCallback, e);
            }
        }
        InternalCallback callback = new InternalCallback(states, exchange, originalCallback, resultProcessor);
        if (exchange.isTransacted()) {
            return SharedCamelInternalProcessor.processTransacted(exchange, processor, callback);
        }
        return SharedCamelInternalProcessor.processNonTransacted(exchange, processor, callback);
    }

    private static boolean handleException(Exchange exchange, AsyncCallback originalCallback, Exception e) {
        exchange.setException((Throwable)e);
        originalCallback.done(true);
        return true;
    }

    private static boolean processNonTransacted(Exchange exchange, AsyncProcessor processor, AsyncCallback callback) {
        UnitOfWork uow = exchange.getUnitOfWork();
        AsyncCallback async = callback;
        boolean beforeAndAfter = uow.isBeforeAfterProcess();
        if (beforeAndAfter) {
            async = uow.beforeProcess((Processor)processor, exchange, async);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        boolean sync = processor.process(exchange, async);
        if (beforeAndAfter) {
            uow.afterProcess((Processor)processor, exchange, callback, sync);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", new Object[]{sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange});
        }
        return sync;
    }

    private static boolean processTransacted(Exchange exchange, AsyncProcessor processor, AsyncCallback callback) {
        if (LOG.isTraceEnabled()) {
            if (exchange.isTransacted()) {
                LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            } else {
                LOG.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
        }
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected boolean continueProcessing(Exchange exchange, AsyncProcessor processor) {
        if (exchange.isRouteStop()) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        if (this.shutdownStrategy.isForceShutdown()) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + String.valueOf(exchange);
            LOG.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException(msg));
            }
            return false;
        }
        return true;
    }

    private final class InternalCallback
    implements AsyncCallback {
        private final Object[] states;
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Processor resultProcessor;

        private InternalCallback(Object[] states, Exchange exchange, AsyncCallback callback, Processor resultProcessor) {
            this.states = states;
            this.exchange = exchange;
            this.callback = callback;
            this.resultProcessor = resultProcessor;
        }

        public void done(boolean doneSync) {
            if (this.resultProcessor != null) {
                try {
                    this.resultProcessor.process(this.exchange);
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                }
            }
            try {
                AdviceIterator.runAfterTasks(SharedCamelInternalProcessor.this.advices, this.states, this.exchange);
            }
            finally {
                if (this.callback != null) {
                    SharedCamelInternalProcessor.this.reactiveExecutor.schedule((Runnable)this.callback);
                }
            }
        }
    }
}

