/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IntrospectionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(IntrospectionSupport.class);
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private static final Map<Class<?>, BeanIntrospection.ClassInfo> CACHE = LRUCacheFactory.newLRUSoftCache((int)1000);
    private static final Pattern SECRETS = Pattern.compile(".*(passphrase|password|secretKey).*", 2);
    private static final Set<Class<?>> PRIMITIVE_CLASSES;

    private IntrospectionSupport() {
    }

    static void stop() {
        IntrospectionSupport.clearCache();
    }

    static void clearCache() {
        Map<Class<?>, BeanIntrospection.ClassInfo> map;
        if (LOG.isDebugEnabled() && (map = CACHE) instanceof LRUCache) {
            LRUCache localCache = (LRUCache)map;
            LOG.debug("Clearing cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{localCache.size(), localCache.getHits(), localCache.getMisses(), localCache.getEvicted()});
        }
        CACHE.clear();
    }

    static long getCacheCounter() {
        return CACHE.size();
    }

    static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        if (name.startsWith("get") && name.length() >= 4 && Character.isUpperCase(name.charAt(3))) {
            return parameterCount == 0 && !type.equals(Void.TYPE);
        }
        if (name.startsWith("is") && name.length() >= 3 && Character.isUpperCase(name.charAt(2))) {
            return parameterCount == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return false;
    }

    static String getGetterShorthandName(Method method) {
        if (!IntrospectionSupport.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = StringHelper.decapitalize((String)name.substring(3));
        } else if (name.startsWith("is")) {
            name = StringHelper.decapitalize((String)name.substring(2));
        }
        return name;
    }

    static String getSetterShorthandName(Method method) {
        if (!IntrospectionSupport.isSetter(method)) {
            return method.getName();
        }
        Object name = method.getName();
        if (((String)name).startsWith("set")) {
            name = ((String)name).substring(3);
            name = ((String)name).substring(0, 1).toLowerCase(Locale.ENGLISH) + ((String)name).substring(1);
        }
        return name;
    }

    static boolean isSetter(Method method, boolean allowBuilderPattern) {
        boolean validName;
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        Class<?> self = method.getDeclaringClass();
        boolean bl = validName = name.startsWith("set") && name.length() >= 4 && Character.isUpperCase(name.charAt(3));
        if (validName && parameterCount == 1) {
            return type.equals(Void.TYPE) || allowBuilderPattern && org.apache.camel.util.ObjectHelper.isSubclass(self, type);
        }
        return allowBuilderPattern && parameterCount == 1 && org.apache.camel.util.ObjectHelper.isSubclass(self, type);
    }

    static boolean isSetter(Method method) {
        return IntrospectionSupport.isSetter(method, false);
    }

    static boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix) {
        return IntrospectionSupport.getProperties(target, properties, optionPrefix, true);
    }

    static boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean includeNull) {
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        BeanIntrospection.ClassInfo cache = IntrospectionSupport.cacheClass(target.getClass());
        for (BeanIntrospection.MethodInfo info : cache.methods) {
            Method method = info.method;
            if (!info.isGetter.booleanValue() || !info.hasGetterAndSetter.booleanValue()) continue;
            String name = info.getterOrSetterShorthandName;
            try {
                Object value = ObjectHelper.invokeMethodSafe((Method)method, (Object)target, null);
                if (value == null && !includeNull) continue;
                properties.put(optionPrefix + name, value);
                rc = true;
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Error invoking getter method {}. This exception is ignored.", (Object)method, (Object)e);
            }
        }
        return rc;
    }

    static BeanIntrospection.ClassInfo cacheClass(Class<?> clazz) {
        BeanIntrospection.ClassInfo cache = CACHE.get(clazz);
        if (cache == null) {
            cache = IntrospectionSupport.doIntrospectClass(clazz);
            CACHE.put(clazz, cache);
        }
        return cache;
    }

    static BeanIntrospection.ClassInfo doIntrospectClass(Class<?> clazz) {
        BeanIntrospection.ClassInfo answer = new BeanIntrospection.ClassInfo();
        answer.clazz = clazz;
        ArrayList<BeanIntrospection.MethodInfo> found = new ArrayList<BeanIntrospection.MethodInfo>();
        Method[] methods = clazz.getMethods();
        HashMap<String, BeanIntrospection.MethodInfo> getters = new HashMap<String, BeanIntrospection.MethodInfo>(methods.length);
        HashMap<String, BeanIntrospection.MethodInfo> setters = new HashMap<String, BeanIntrospection.MethodInfo>(methods.length);
        for (Method method : methods) {
            if (EXCLUDED_METHODS.contains(method)) continue;
            BeanIntrospection.MethodInfo cache = new BeanIntrospection.MethodInfo();
            cache.method = method;
            if (IntrospectionSupport.isGetter(method)) {
                cache.isGetter = true;
                cache.isSetter = false;
                cache.getterOrSetterShorthandName = IntrospectionSupport.getGetterShorthandName(method);
                getters.put(cache.getterOrSetterShorthandName, cache);
            } else if (IntrospectionSupport.isSetter(method)) {
                cache.isGetter = false;
                cache.isSetter = true;
                cache.getterOrSetterShorthandName = IntrospectionSupport.getSetterShorthandName(method);
                setters.put(cache.getterOrSetterShorthandName, cache);
            } else {
                cache.isGetter = false;
                cache.isSetter = false;
            }
            found.add(cache);
        }
        for (BeanIntrospection.MethodInfo info : found) {
            info.hasGetterAndSetter = false;
            if (info.isGetter.booleanValue()) {
                info.hasGetterAndSetter = setters.containsKey(info.getterOrSetterShorthandName);
                continue;
            }
            if (!info.isSetter.booleanValue()) continue;
            info.hasGetterAndSetter = getters.containsKey(info.getterOrSetterShorthandName);
        }
        answer.methods = found.toArray(new BeanIntrospection.MethodInfo[0]);
        return answer;
    }

    static Object getProperty(Object target, String propertyName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull((Object)propertyName, (String)"property");
        propertyName = StringHelper.capitalize((String)propertyName);
        Class<?> clazz = target.getClass();
        Method method = IntrospectionSupport.getPropertyGetter(clazz, propertyName);
        return method.invoke(target, new Object[0]);
    }

    static Object getOrElseProperty(Object target, String propertyName, Object defaultValue, boolean ignoreCase) {
        try {
            if (ignoreCase) {
                Class<?> clazz = target.getClass();
                Method method = IntrospectionSupport.getPropertyGetter(clazz, propertyName, true);
                if (method != null) {
                    return method.invoke(target, new Object[0]);
                }
                return defaultValue;
            }
            return IntrospectionSupport.getProperty(target, propertyName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static Method getPropertyGetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        return IntrospectionSupport.getPropertyGetter(type, propertyName, false);
    }

    static Method getPropertyGetter(Class<?> type, String propertyName, boolean ignoreCase) throws NoSuchMethodException {
        if (ignoreCase) {
            ArrayList<Method> methods = new ArrayList<Method>();
            methods.addAll(Arrays.asList(type.getDeclaredMethods()));
            methods.addAll(Arrays.asList(type.getMethods()));
            for (Method m : methods) {
                if (!IntrospectionSupport.isGetter(m)) continue;
                if (m.getName().startsWith("is") && m.getName().substring(2).equalsIgnoreCase(propertyName)) {
                    return m;
                }
                if (!m.getName().startsWith("get") || !m.getName().substring(3).equalsIgnoreCase(propertyName)) continue;
                return m;
            }
            return null;
        }
        if (IntrospectionSupport.isPropertyIsGetter(type, propertyName)) {
            return type.getMethod("is" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
        }
        return type.getMethod("get" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
    }

    static Method getPropertySetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        String name = "set" + StringHelper.capitalize((String)propertyName, (boolean)true);
        for (Method method : type.getMethods()) {
            if (!IntrospectionSupport.isSetter(method) || !method.getName().equals(name)) continue;
            return method;
        }
        throw new NoSuchMethodException(type.getCanonicalName() + "." + name);
    }

    static boolean isPropertyIsGetter(Class<?> type, String propertyName) {
        try {
            Method method = type.getMethod("is" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
            if (method != null) {
                return method.getReturnType().isAssignableFrom(Boolean.TYPE) || method.getReturnType().isAssignableFrom(Boolean.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern) throws Exception {
        return IntrospectionSupport.setProperty(context, typeConverter, target, name, value, refName, allowBuilderPattern, false, false);
    }

    static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) throws Exception {
        if (name.contains("[") && name.endsWith("]")) {
            int pos = name.indexOf(91);
            String lookupKey = name.substring(pos + 1, name.length() - 1);
            String key = name.substring(0, pos);
            Object obj = IntrospectionSupport.getOrElseProperty(target, key, null, ignoreCase);
            if (obj == null) {
                Method getter = IntrospectionSupport.getPropertyGetter(target.getClass(), key, ignoreCase);
                if (getter != null) {
                    Class<?> returnType = getter.getReturnType();
                    if (Map.class.isAssignableFrom(returnType)) {
                        obj = new LinkedHashMap();
                    } else if (Collection.class.isAssignableFrom(returnType)) {
                        obj = new ArrayList();
                    } else if (returnType.isArray()) {
                        obj = Array.newInstance(returnType.getComponentType(), 0);
                    }
                } else {
                    obj = new LinkedHashMap();
                }
                boolean hit = IntrospectionSupport.setProperty(context, target, key, obj);
                if (!hit) {
                    throw new IllegalArgumentException("Cannot set property: " + name + " as a Map because target bean has no setter method for the Map");
                }
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (context != null && refName != null && value == null) {
                    String s = refName.replace("#", "");
                    value = CamelContextHelper.lookup((CamelContext)context, (String)s);
                }
                map.put(lookupKey, value);
                return true;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                if (context != null && refName != null && value == null) {
                    String s = refName.replace("#", "");
                    value = CamelContextHelper.lookup((CamelContext)context, (String)s);
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)lookupKey)) {
                    int idx = Integer.parseInt(lookupKey);
                    if (idx < list.size()) {
                        list.set(idx, value);
                    } else if (idx == list.size()) {
                        list.add(value);
                    } else {
                        if (list instanceof ArrayList) {
                            ((ArrayList)list).ensureCapacity(idx + 1);
                        }
                        while (list.size() < idx) {
                            list.add(null);
                        }
                        list.add(idx, value);
                    }
                } else {
                    list.add(value);
                }
                return true;
            }
            if (obj.getClass().isArray() && lookupKey != null) {
                boolean hit;
                int size;
                int idx;
                if (context != null && refName != null && value == null) {
                    String s = refName.replace("#", "");
                    value = CamelContextHelper.lookup((CamelContext)context, (String)s);
                }
                if ((idx = Integer.parseInt(lookupKey)) >= (size = Array.getLength(obj)) && !(hit = IntrospectionSupport.setProperty(context, target, key, obj = Arrays.copyOf((Object[])obj, idx + 1)))) {
                    throw new IllegalArgumentException("Cannot set property: " + name + " as an array because target bean has no setter method for the array");
                }
                Array.set(obj, idx, value);
                return true;
            }
            throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target));
        }
        Class<?> clazz = target.getClass();
        Collection<Method> setters = context != null && refName != null && value == null ? IntrospectionSupport.findSetterMethodsOrderedByParameterType(clazz, name, allowBuilderPattern, allowPrivateSetter, ignoreCase) : IntrospectionSupport.findSetterMethods(clazz, name, value, allowBuilderPattern, allowPrivateSetter, ignoreCase);
        if (setters.isEmpty()) {
            return false;
        }
        Throwable typeConversionFailed = null;
        Method stringSetterMethod = null;
        Iterator<Method> it = setters.iterator();
        while (it.hasNext()) {
            Method setter = it.next();
            Class<?> parameterType = setter.getParameterTypes()[0];
            if (parameterType.getName().equals("java.lang.String")) {
                stringSetterMethod = setter;
            }
            Object ref = value;
            if (context != null && refName != null && ref == null) {
                String s = refName.replace("#", "");
                ref = CamelContextHelper.lookup((CamelContext)context, (String)s);
                if (ref == null) {
                    if (it.hasNext() || stringSetterMethod == null) continue;
                    setter = stringSetterMethod;
                    ref = refName;
                } else {
                    boolean assignable = org.apache.camel.util.ObjectHelper.isAssignableFrom(parameterType, ref.getClass());
                    if (!assignable) continue;
                }
            }
            boolean myself = false;
            try {
                try {
                    String val;
                    if (value == null || org.apache.camel.util.ObjectHelper.isAssignableFrom(parameterType, ref.getClass())) {
                        setter.setAccessible(true);
                        setter.invoke(target, ref);
                        if (LOG.isTraceEnabled()) {
                            String val2;
                            String string = val2 = ref != null ? ref.toString() : "";
                            if (SECRETS.matcher(name).find()) {
                                val2 = "xxxxxx";
                            }
                            LOG.trace("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, val2});
                        }
                        return true;
                    }
                    if (!(parameterType != Boolean.class && parameterType != Boolean.TYPE || !(ref instanceof String) || (val = (String)ref).equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))) {
                        myself = true;
                        throw new IllegalArgumentException("Cannot convert the String value: " + String.valueOf(ref) + " to type: " + String.valueOf(parameterType) + " as the value is not true or false");
                    }
                    Object convertedValue = typeConverter != null ? typeConverter.mandatoryConvertTo(parameterType, ref) : ref;
                    setter.setAccessible(true);
                    setter.invoke(target, convertedValue);
                    if (LOG.isTraceEnabled()) {
                        String val3 = ref.toString();
                        if (SECRETS.matcher(name).find()) {
                            val3 = "xxxxxx";
                        }
                        LOG.trace("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, val3});
                    }
                    return true;
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw (Error)throwable;
                }
            }
            catch (IllegalArgumentException e) {
                if (myself) {
                    typeConversionFailed = e;
                }
                throw e;
            }
            catch (SecurityException | NoTypeConversionAvailableException e) {
                typeConversionFailed = e;
            }
            LOG.trace("Setter \"{}\" with parameter type \"{}\" could not be used for type conversions of {}", new Object[]{setter, parameterType, ref});
        }
        if (typeConversionFailed != null && !IntrospectionSupport.isPropertyPlaceholder(context, value)) {
            throw new IllegalArgumentException("Could not find a suitable setter for property: " + name + " as there isn't a setter method with same type: " + (value != null ? value.getClass().getCanonicalName() : "[null]") + " nor type conversion possible: " + typeConversionFailed.getMessage());
        }
        return false;
    }

    static boolean isPropertyPlaceholder(CamelContext context, Object value) {
        if (context != null && value != null) {
            String text = value.toString();
            return text.contains("{{") && text.contains("}}");
        }
        return false;
    }

    static boolean setProperty(CamelContext context, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(context, context != null ? context.getTypeConverter() : null, target, name, value, null, true, false, false);
    }

    static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(context, typeConverter, target, name, value, null, true, false, false);
    }

    static boolean setProperty(TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(null, typeConverter, target, name, value, null, true, false, false);
    }

    static boolean setProperty(Object target, String name, Object value, boolean allowBuilderPattern) throws Exception {
        return IntrospectionSupport.setProperty(null, null, target, name, value, null, allowBuilderPattern, false, false);
    }

    static boolean setProperty(Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(target, name, value, true);
    }

    static Set<Method> findSetterMethods(Class<?> clazz, String name, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) {
        LinkedHashSet<Method> candidates = new LinkedHashSet<Method>();
        String builderName = "with" + StringHelper.capitalize((String)name, (boolean)true);
        Object builderName2 = StringHelper.capitalize((String)name, (boolean)true);
        builderName2 = Character.toLowerCase(((String)builderName2).charAt(0)) + ((String)builderName2).substring(1);
        String setName = "set" + StringHelper.capitalize((String)name, (boolean)true);
        while (clazz != Object.class) {
            Method[] methods;
            Method objectSetMethod = null;
            for (Method method : methods = allowPrivateSetter ? clazz.getDeclaredMethods() : clazz.getMethods()) {
                boolean validName;
                if (ignoreCase) {
                    validName = method.getName().equalsIgnoreCase(setName) || allowBuilderPattern && method.getName().equalsIgnoreCase(builderName) || allowBuilderPattern && method.getName().equalsIgnoreCase((String)builderName2);
                } else {
                    boolean bl = validName = method.getName().equals(setName) || allowBuilderPattern && method.getName().equals(builderName) || allowBuilderPattern && method.getName().equals(builderName2);
                }
                if (!validName || !IntrospectionSupport.isSetter(method, allowBuilderPattern)) continue;
                Class<?>[] params = method.getParameterTypes();
                if (params[0].equals(Object.class)) {
                    objectSetMethod = method;
                    continue;
                }
                candidates.add(method);
            }
            if (objectSetMethod != null) {
                candidates.add(objectSetMethod);
            }
            clazz = clazz.getSuperclass();
        }
        return candidates;
    }

    static Set<Method> findSetterMethods(Class<?> clazz, String name, Object value, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) {
        Set<Method> candidates = IntrospectionSupport.findSetterMethods(clazz, name, allowBuilderPattern, allowPrivateSetter, ignoreCase);
        if (candidates.isEmpty()) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        LOG.trace("Found {} suitable setter methods for setting {}", (Object)candidates.size(), (Object)name);
        for (Method method : candidates) {
            if (!method.getParameterTypes()[0].isInstance(value)) continue;
            LOG.trace("Method {} is the best candidate as it has parameter with same instance type", (Object)method);
            candidates.clear();
            candidates.add(method);
            return candidates;
        }
        return candidates;
    }

    static List<Method> findSetterMethodsOrderedByParameterType(Class<?> target, String propertyName, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) {
        LinkedList<Method> answer = new LinkedList<Method>();
        LinkedList<Method> primitives = new LinkedList<Method>();
        Set<Method> setters = IntrospectionSupport.findSetterMethods(target, propertyName, allowBuilderPattern, allowPrivateSetter, ignoreCase);
        for (Method setter : setters) {
            Class<?> parameterType = setter.getParameterTypes()[0];
            if (PRIMITIVE_CLASSES.contains(parameterType)) {
                primitives.add(setter);
                continue;
            }
            answer.add(setter);
        }
        answer.addAll(primitives);
        return answer;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
        PRIMITIVE_CLASSES = new HashSet();
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSES.add(Byte.class);
        PRIMITIVE_CLASSES.add(Short.class);
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSES.add(Character.TYPE);
        PRIMITIVE_CLASSES.add(Boolean.TYPE);
        PRIMITIVE_CLASSES.add(Byte.TYPE);
        PRIMITIVE_CLASSES.add(Short.TYPE);
        PRIMITIVE_CLASSES.add(Integer.TYPE);
        PRIMITIVE_CLASSES.add(Long.TYPE);
        PRIMITIVE_CLASSES.add(Float.TYPE);
        PRIMITIVE_CLASSES.add(Double.TYPE);
    }
}

