/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.DefaultSchemaResolver;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.SerdeConfig;
import java.util.Map;
import java.util.Objects;

public class SchemaResolverConfigurer<T, U> {
    protected SchemaResolver<T, U> schemaResolver;

    public SchemaResolverConfigurer() {
    }

    public SchemaResolverConfigurer(RegistryClient client) {
        this(client, (SchemaResolver<T, U>)new DefaultSchemaResolver());
    }

    public SchemaResolverConfigurer(SchemaResolver<T, U> schemaResolver) {
        this(null, schemaResolver);
    }

    public SchemaResolverConfigurer(RegistryClient client, SchemaResolver<T, U> schemaResolver) {
        this();
        this.setSchemaResolver(schemaResolver);
        this.getSchemaResolver().setClient(client);
    }

    public SchemaResolver<T, U> getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaResolver<T, U> schemaResolver) {
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    protected void configure(Map<String, Object> configs, boolean isKey, SchemaParser<T, U> schemaParser) {
        Objects.requireNonNull(configs);
        Objects.requireNonNull(schemaParser);
        if (this.schemaResolver == null) {
            Object sr = configs.get("apicurio.registry.schema-resolver");
            if (null == sr) {
                this.setSchemaResolver((SchemaResolver<T, U>)new DefaultSchemaResolver());
            } else {
                Utils.instantiate(SchemaResolver.class, (Object)sr, this::setSchemaResolver);
            }
        }
        if (!configs.containsKey("apicurio.registry.artifact-resolver-strategy")) {
            configs.put("apicurio.registry.artifact-resolver-strategy", SerdeConfig.ARTIFACT_RESOLVER_STRATEGY_DEFAULT);
        }
        configs.put("apicurio.registry.is-key", isKey);
        this.getSchemaResolver().configure(configs, schemaParser);
    }
}

