/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractReifier
implements BeanRepository {
    protected final Route route;
    protected final CamelContext camelContext;

    public AbstractReifier(Route route) {
        this.route = (Route)ObjectHelper.notNull((Object)route, (String)"Route");
        this.camelContext = route.getCamelContext();
    }

    public AbstractReifier(CamelContext camelContext) {
        this.route = null;
        this.camelContext = (CamelContext)ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
    }

    protected CamelContext getCamelContext() {
        return this.camelContext;
    }

    protected String parseString(String text) {
        return CamelContextHelper.parseText((CamelContext)this.camelContext, (String)text);
    }

    protected Boolean parseBoolean(String text) {
        return CamelContextHelper.parseBoolean((CamelContext)this.camelContext, (String)text);
    }

    protected boolean parseBoolean(String text, boolean def) {
        Boolean b = this.parseBoolean(text);
        return b != null ? b : def;
    }

    protected Long parseLong(String text) {
        return CamelContextHelper.parseLong((CamelContext)this.camelContext, (String)text);
    }

    protected long parseLong(String text, long def) {
        Long l = this.parseLong(text);
        return l != null ? l : def;
    }

    protected Long parseDuration(String text) {
        Duration d = CamelContextHelper.parseDuration((CamelContext)this.camelContext, (String)text);
        return d != null ? Long.valueOf(d.toMillis()) : null;
    }

    protected long parseDuration(String text, long def) {
        Duration d = CamelContextHelper.parseDuration((CamelContext)this.camelContext, (String)text);
        return d != null ? d.toMillis() : def;
    }

    protected Integer parseInt(String text) {
        return CamelContextHelper.parseInteger((CamelContext)this.camelContext, (String)text);
    }

    protected int parseInt(String text, int def) {
        Integer i = this.parseInt(text);
        return i != null ? i : def;
    }

    protected Float parseFloat(String text) {
        return CamelContextHelper.parseFloat((CamelContext)this.camelContext, (String)text);
    }

    protected float parseFloat(String text, float def) {
        Float f = this.parseFloat(text);
        return f != null ? f.floatValue() : def;
    }

    protected <T> T parse(Class<T> clazz, String text) {
        return (T)CamelContextHelper.parse((CamelContext)this.camelContext, clazz, (String)text);
    }

    protected <T> T parse(Class<T> clazz, Object text) {
        if (text instanceof String) {
            text = this.parseString((String)text);
        }
        return (T)CamelContextHelper.convertTo((CamelContext)this.camelContext, clazz, (Object)text);
    }

    protected Expression createExpression(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Expression createExpression(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Predicate createPredicate(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Predicate createPredicate(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Object or(Object a, Object b) {
        return a != null ? a : b;
    }

    protected Object asRef(String s) {
        return s != null ? (s.startsWith("#") ? s : "#" + s) : null;
    }

    protected BeanRepository getRegistry() {
        return this.camelContext.getRegistry();
    }

    public <T> T mandatoryLookup(String name, Class<T> type) {
        T obj = this.lookupByNameAndType(name, type);
        if (obj == null) {
            throw new NoSuchBeanException(name, type.getName());
        }
        return type.cast(obj);
    }

    public Object lookupByName(String name) {
        if (name == null) {
            return null;
        }
        if (EndpointHelper.isReferenceParameter((String)name)) {
            return EndpointHelper.resolveReferenceParameter((CamelContext)this.camelContext, (String)name, Object.class, (boolean)false);
        }
        return this.getRegistry().lookupByName(name);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        if (name == null) {
            return null;
        }
        if (EndpointHelper.isReferenceParameter((String)name)) {
            return (T)EndpointHelper.resolveReferenceParameter((CamelContext)this.camelContext, (String)name, type, (boolean)false);
        }
        return (T)this.getRegistry().lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return this.getRegistry().findByTypeWithName(type);
    }

    public <T> Set<T> findByType(Class<T> type) {
        return this.getRegistry().findByType(type);
    }

    public Object unwrap(Object value) {
        return this.getRegistry().unwrap(value);
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)uri);
    }
}

