/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarDecoder;
import java.io.IOException;

public abstract class MapReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_NAME = 1;
    protected static final int STATE_VALUE = 2;
    protected static final int STATE_END = 3;
    protected static final int STATE_DONE = 4;
    protected final AvroParserImpl _parser;
    protected final String _keyTypeId;
    protected final String _valueTypeId;
    protected String _currentName;
    protected int _state;

    protected MapReader(String typeId, String keyTypeId, String valueTypeId) throws IOException {
        this(null, null, typeId, keyTypeId, valueTypeId);
    }

    protected MapReader(AvroReadContext parent, AvroParserImpl parser, String typeId, String keyTypeId, String valueTypeId) throws IOException {
        super(parent, 2, typeId);
        this._parser = parser;
        this._keyTypeId = keyTypeId;
        this._valueTypeId = valueTypeId;
        if (parser != null) {
            parser.streamReadConstraints().validateNestingDepth(this._nestingDepth);
        }
    }

    public static MapReader construct(ScalarDecoder dec, String typeId, String keyTypeId, String valueTypeId) throws IOException {
        return new Scalar(dec, typeId, keyTypeId, valueTypeId);
    }

    public static MapReader construct(AvroStructureReader reader, String typeId, String keyTypeId) throws IOException {
        return new NonScalar(reader, typeId, keyTypeId);
    }

    @Override
    public abstract MapReader newReader(AvroReadContext var1, AvroParserImpl var2) throws IOException;

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public abstract JsonToken nextToken() throws IOException;

    @Override
    public abstract void skipValue(AvroParserImpl var1) throws IOException;

    @Override
    public abstract long getRemainingElements();

    @Override
    public String nextFieldName() throws IOException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.FIELD_NAME) {
            return this._currentName;
        }
        return null;
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this._currentName != null) {
            sb.append('\"');
            sb.append(this._currentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append('}');
    }

    @Override
    public String getTypeId() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.END_OBJECT) {
            return super.getTypeId();
        }
        if (this._currToken == JsonToken.FIELD_NAME && this._state == 2) {
            return this._keyTypeId;
        }
        return this._valueTypeId;
    }

    private static final class NonScalar
    extends MapReader {
        private final AvroStructureReader _structureReader;
        protected long _count;

        public NonScalar(AvroStructureReader reader, String typeId, String keyTypeId) throws IOException {
            super(typeId, keyTypeId, null);
            this._structureReader = reader;
        }

        public NonScalar(AvroReadContext parent, AvroParserImpl parser, AvroStructureReader reader, String typeId, String keyTypeId) throws IOException {
            super(parent, parser, typeId, keyTypeId, null);
            this._structureReader = reader;
        }

        @Override
        public long getRemainingElements() {
            return this._count - (long)this._index;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return new NonScalar(parent, parser, this._structureReader, this._typeId, this._keyTypeId);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._parser.decodeMapStart();
                    this._state = this._count > 0L ? 1 : 3;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) {
                        this._state = 2;
                        this._currentName = this._parser.decodeMapKey();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    this._count = this._parser.decodeMapNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        this._currentName = this._parser.decodeMapKey();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                }
                case 3: {
                    this._state = 4;
                    this._parser.setAvroContext(this.getParent());
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    break;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            ++this._index;
            AvroStructureReader r = this._structureReader.newReader(this, this._parser);
            this._parser.setAvroContext(r);
            this._currToken = r.nextToken();
            return this._currToken;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
            long l;
            while ((l = parser.skipMap()) > 0L) {
                while (--l >= 0L) {
                    this._structureReader.skipValue(parser);
                }
            }
        }
    }

    private static final class Scalar
    extends MapReader {
        private final ScalarDecoder _scalarDecoder;
        protected long _count;

        protected Scalar(ScalarDecoder dec, String typeId, String keyTypeId, String valueTypeId) throws IOException {
            super(typeId, keyTypeId, valueTypeId != null ? valueTypeId : dec.getTypeId());
            this._scalarDecoder = dec;
        }

        protected Scalar(AvroReadContext parent, AvroParserImpl parser, ScalarDecoder sd, String typeId, String keyTypeId, String valueTypeId) throws IOException {
            super(parent, parser, typeId, keyTypeId, valueTypeId != null ? valueTypeId : sd.getTypeId());
            this._scalarDecoder = sd;
        }

        @Override
        public long getRemainingElements() {
            return this._count - (long)this._index;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return new Scalar(parent, parser, this._scalarDecoder, this._typeId, this._keyTypeId, this._valueTypeId);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._parser.decodeMapStart();
                    this._state = this._count > 0L ? 1 : 3;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) {
                        this._state = 2;
                        this._currentName = this._parser.decodeMapKey();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    this._count = this._parser.decodeMapNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        this._currentName = this._parser.decodeMapKey();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                }
                case 3: {
                    this._state = 4;
                    this._parser.setAvroContext(this.getParent());
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    break;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            ++this._index;
            return this._scalarDecoder.decodeValue(this._parser);
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
            long l;
            while ((l = parser.skipMap()) > 0L) {
                while (--l >= 0L) {
                    this._scalarDecoder.skipValue(parser);
                }
            }
        }
    }
}

