/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Locale;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.0.0", label="dataformat,transformation,csv", title="Bindy")
@XmlRootElement(name="bindy")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BindyDataFormat
extends DataFormatDefinition {
    private Class<?> classType;
    @XmlAttribute(required=true)
    @Metadata(required=true, javaType="org.apache.camel.model.dataformat.BindyType", enums="Csv,Fixed,KeyValue")
    private String type;
    @XmlAttribute(name="classType")
    private String classTypeAsString;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String allowEmptyStream;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String unwrapSingleInstance;
    @XmlAttribute
    @Metadata(label="advanced")
    private String locale;

    public BindyDataFormat() {
        super("bindy");
    }

    private BindyDataFormat(Builder builder) {
        this();
        this.classType = builder.classType;
        this.type = builder.type;
        this.classTypeAsString = builder.classTypeAsString;
        this.allowEmptyStream = builder.allowEmptyStream;
        this.unwrapSingleInstance = builder.unwrapSingleInstance;
        this.locale = builder.locale;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassTypeAsString() {
        return this.classTypeAsString;
    }

    public void setClassTypeAsString(String classType) {
        this.classTypeAsString = classType;
    }

    @Override
    public String getDataFormatName() {
        if ("Csv".equals(this.type)) {
            return "bindyCsv";
        }
        if ("Fixed".equals(this.type)) {
            return "bindyFixed";
        }
        return "bindyKvp";
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getUnwrapSingleInstance() {
        return this.unwrapSingleInstance;
    }

    public void setUnwrapSingleInstance(String unwrapSingleInstance) {
        this.unwrapSingleInstance = unwrapSingleInstance;
    }

    public String getAllowEmptyStream() {
        return this.allowEmptyStream;
    }

    public void setAllowEmptyStream(String allowEmptyStream) {
        this.allowEmptyStream = allowEmptyStream;
    }

    public BindyDataFormat csv() {
        return this.type(BindyType.Csv);
    }

    public BindyDataFormat fixed() {
        return this.type(BindyType.Fixed);
    }

    public BindyDataFormat keyValue() {
        return this.type(BindyType.KeyValue);
    }

    public BindyDataFormat type(BindyType type) {
        return this.type(type.name());
    }

    public BindyDataFormat type(String type) {
        this.type = type;
        return this;
    }

    public BindyDataFormat classType(Class<?> classType) {
        this.classType = classType;
        return this;
    }

    public BindyDataFormat classType(String classType) {
        this.classTypeAsString = classType;
        return this;
    }

    public BindyDataFormat locale(Locale locale) {
        return this.locale((String)(locale.getCountry().isEmpty() ? locale.getLanguage() : locale.getLanguage() + "-" + locale.getCountry()));
    }

    public BindyDataFormat locale(String locale) {
        this.locale = locale;
        return this;
    }

    public BindyDataFormat unwrapSingleInstance(boolean unwrapSingleInstance) {
        return this.unwrapSingleInstance(Boolean.toString(unwrapSingleInstance));
    }

    public BindyDataFormat unwrapSingleInstance(String unwrapSingleInstance) {
        this.unwrapSingleInstance = unwrapSingleInstance;
        return this;
    }

    public BindyDataFormat allowEmptyStream(boolean allowEmptyStream) {
        return this.allowEmptyStream(Boolean.toString(allowEmptyStream));
    }

    public BindyDataFormat allowEmptyStream(String allowEmptyStream) {
        this.allowEmptyStream = allowEmptyStream;
        return this;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<BindyDataFormat> {
        private Class<?> classType;
        private String type;
        private String classTypeAsString;
        private String allowEmptyStream;
        private String unwrapSingleInstance;
        private String locale;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder type(BindyType type) {
            return this.type(type.name());
        }

        public Builder classType(String classTypeAsString) {
            this.classTypeAsString = classTypeAsString;
            return this;
        }

        public Builder classType(Class<?> classType) {
            this.classType = classType;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder unwrapSingleInstance(String unwrapSingleInstance) {
            this.unwrapSingleInstance = unwrapSingleInstance;
            return this;
        }

        public Builder unwrapSingleInstance(boolean unwrapSingleInstance) {
            this.unwrapSingleInstance = Boolean.toString(unwrapSingleInstance);
            return this;
        }

        public Builder allowEmptyStream(String allowEmptyStream) {
            this.allowEmptyStream = allowEmptyStream;
            return this;
        }

        public Builder allowEmptyStream(boolean allowEmptyStream) {
            this.allowEmptyStream = Boolean.toString(allowEmptyStream);
            return this;
        }

        @Override
        public BindyDataFormat end() {
            return new BindyDataFormat(this);
        }
    }
}

