/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.config;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration,eip")
@XmlRootElement(name="batchConfig")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BatchResequencerConfig
extends ResequencerConfig {
    @XmlAttribute
    @Metadata(defaultValue="100", javaType="java.lang.Integer")
    private String batchSize;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String batchTimeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowDuplicates;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String reverse;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreInvalidExchanges;

    public BatchResequencerConfig() {
        this(100, 1000L);
    }

    public BatchResequencerConfig(int batchSize, long batchTimeout) {
        this.batchSize = Integer.toString(batchSize);
        this.batchTimeout = Long.toString(batchTimeout);
    }

    public static BatchResequencerConfig getDefault() {
        return new BatchResequencerConfig();
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(String batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public String getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(String allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public String getReverse() {
        return this.reverse;
    }

    public void setReverse(String reverse) {
        this.reverse = reverse;
    }

    public String getIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(String ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }
}

