/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-filter")
@XmlRootElement(name="blacklistServiceFilter")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
@Deprecated
public class BlacklistServiceCallServiceFilterConfiguration
extends ServiceCallServiceFilterConfiguration {
    @XmlElement
    private List<String> servers;

    public BlacklistServiceCallServiceFilterConfiguration() {
        this(null);
    }

    public BlacklistServiceCallServiceFilterConfiguration(ServiceCallDefinition parent) {
        super(parent, "blacklist-service-filter");
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public BlacklistServiceCallServiceFilterConfiguration servers(List<String> servers) {
        this.setServers(servers);
        return this;
    }

    public BlacklistServiceCallServiceFilterConfiguration servers(String servers) {
        if (ObjectHelper.isNotEmpty((String)servers)) {
            String[] parts = servers.split(",");
            if (this.servers == null) {
                this.servers = new ArrayList<String>();
            }
            this.servers.addAll(Arrays.asList(parts));
        }
        return this;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        List servers = (List)List.class.cast(parameters.get("servers"));
        if (ObjectHelper.isNotEmpty((Collection)servers)) {
            ListIterator<String> it = servers.listIterator();
            while (it.hasNext()) {
                it.set(camelContext.resolvePropertyPlaceholders((String)it.next()));
            }
            parameters.put("servers", servers);
        }
    }
}

