/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.support.MonotonicClock;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final MonotonicClock clock = new MonotonicClock();
    private final Message message;
    private long elapsed;

    public DefaultMessageHistory(String routeId, NamedNode node) {
        this(routeId, node, null);
    }

    public DefaultMessageHistory(String routeId, NamedNode node, Message message) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.message = message;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public NamedNode getNode() {
        return this.node;
    }

    public long getTime() {
        return this.clock.getCreated();
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void nodeProcessingDone() {
        this.elapsed = this.clock.elapsed();
    }

    public Message getMessage() {
        return this.message;
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + "]";
    }
}

