/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.SimpleMain;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.idempotent.kafka.KafkaIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.SensitiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelKafkaConnectMain
extends SimpleMain {
    public static final String KAMELET_MARSHAL_TEMPLATE_PARAMETERS_PREFIX = "camel.kamelet.ckcMarshal.";
    public static final String KAMELET_UNMARSHAL_TEMPLATE_PARAMETERS_PREFIX = "camel.kamelet.ckcUnMarshal.";
    public static final String KAMELET_AGGREGATORL_TEMPLATE_PARAMETERS_PREFIX = "camel.kamelet.ckcAggregator.";
    public static final String KAMELET_IDEMPOTENT_TEMPLATE_PARAMETERS_PREFIX = "camel.kamelet.ckcIdempotent.";
    public static final String KAMELET_REMOVEHEADER_TEMPLATE_PARAMETERS_PREFIX = "camel.kamelet.ckcRemoveHeader.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelKafkaConnectMain.class);
    protected volatile ConsumerTemplate consumerTemplate;
    protected volatile ProducerTemplate producerTemplate;

    public CamelKafkaConnectMain(CamelContext context) {
        super(context);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.consumerTemplate);
        this.consumerTemplate = null;
        ServiceHelper.stopService((Object)this.producerTemplate);
        this.producerTemplate = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerTemplate getProducerTemplate() {
        if (this.producerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.producerTemplate == null) {
                    this.producerTemplate = this.getCamelContext().createProducerTemplate();
                }
            }
        }
        return this.producerTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerTemplate getConsumerTemplate() {
        if (this.consumerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.consumerTemplate == null) {
                    this.consumerTemplate = this.getCamelContext().createConsumerTemplate();
                }
            }
        }
        return this.consumerTemplate;
    }

    public static Builder builder(String from, String to) {
        return new Builder(from, to);
    }

    public static final class Builder {
        private final String from;
        private final String to;
        private Map<String, String> props;
        private String marshallDataFormat;
        private String unmarshallDataFormat;
        private int aggregationSize;
        private long aggregationTimeout;
        private String errorHandler;
        private int maxRedeliveries;
        private long redeliveryDelay;
        private boolean idempotencyEnabled;
        private String expressionType;
        private String expressionHeader;
        private int memoryDimension;
        private String idempotentRepositoryType;
        private String idempotentRepositoryTopicName;
        private String idempotentRepositoryKafkaServers;
        private int idempotentRepositoryKafkaMaxCacheSize;
        private int idempotentRepositoryKafkaPollDuration;
        private String headersExcludePattern;

        public Builder(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public Builder withProperties(Map<String, String> props) {
            this.props = new HashMap<String, String>(props);
            return this;
        }

        public Builder withMarshallDataFormat(String dataformatId) {
            this.marshallDataFormat = dataformatId;
            return this;
        }

        public Builder withUnmarshallDataFormat(String dataformatId) {
            this.unmarshallDataFormat = dataformatId;
            return this;
        }

        public Builder withAggregationSize(int aggregationSize) {
            this.aggregationSize = aggregationSize;
            return this;
        }

        public Builder withAggregationTimeout(long aggregationTimeout) {
            this.aggregationTimeout = aggregationTimeout;
            return this;
        }

        public Builder withErrorHandler(String errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withMaxRedeliveries(int maxRedeliveries) {
            this.maxRedeliveries = maxRedeliveries;
            return this;
        }

        public Builder withRedeliveryDelay(long redeliveryDelay) {
            this.redeliveryDelay = redeliveryDelay;
            return this;
        }

        public Builder withIdempotencyEnabled(boolean idempotencyEnabled) {
            this.idempotencyEnabled = idempotencyEnabled;
            return this;
        }

        public Builder withExpressionType(String expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        public Builder withExpressionHeader(String expressionHeader) {
            this.expressionHeader = expressionHeader;
            return this;
        }

        public Builder withMemoryDimension(int memoryDimension) {
            this.memoryDimension = memoryDimension;
            return this;
        }

        public Builder withIdempotentRepositoryType(String idempotentRepositoryType) {
            this.idempotentRepositoryType = idempotentRepositoryType;
            return this;
        }

        public Builder withIdempotentRepositoryTopicName(String idempotentRepositoryTopicName) {
            this.idempotentRepositoryTopicName = idempotentRepositoryTopicName;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaServers(String idempotentRepositoryKafkaServers) {
            this.idempotentRepositoryKafkaServers = idempotentRepositoryKafkaServers;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaMaxCacheSize(int idempotentRepositoryKafkaMaxCacheSize) {
            this.idempotentRepositoryKafkaMaxCacheSize = idempotentRepositoryKafkaMaxCacheSize;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaPollDuration(int idempotentRepositoryKafkaPollDuration) {
            this.idempotentRepositoryKafkaPollDuration = idempotentRepositoryKafkaPollDuration;
            return this;
        }

        public Builder withHeadersExcludePattern(String headersExcludePattern) {
            this.headersExcludePattern = headersExcludePattern;
            return this;
        }

        private String filterSensitive(Map.Entry<Object, Object> entry) {
            if (SensitiveUtils.containsSensitive((String)((String)entry.getKey()))) {
                return entry.getKey() + "=xxxxxxx";
            }
            return entry.getKey() + "=" + entry.getValue();
        }

        public CamelKafkaConnectMain build(CamelContext camelContext) {
            CamelKafkaConnectMain camelMain = new CamelKafkaConnectMain(camelContext);
            camelMain.configure().setAutoConfigurationLogSummary(false);
            camelMain.configure().setDumpRoutes(true);
            Properties camelProperties = new Properties();
            camelProperties.putAll(this.props);
            camelMain.getCamelContext().getRegistry().bind("ckcErrorHandler", (Object)new DefaultErrorHandlerBuilder());
            if (this.errorHandler != null) {
                switch (this.errorHandler) {
                    case "no": {
                        camelMain.getCamelContext().getRegistry().bind("ckcErrorHandler", (Object)new NoErrorHandlerBuilder());
                        break;
                    }
                    case "default": {
                        camelMain.getCamelContext().getRegistry().bind("ckcErrorHandler", (Object)new DefaultErrorHandlerBuilder().maximumRedeliveries(this.maxRedeliveries).redeliveryDelay(this.redeliveryDelay));
                        break;
                    }
                }
            }
            if (!ObjectHelper.isEmpty((Object)this.marshallDataFormat)) {
                camelProperties.put("camel.kamelet.ckcMarshal.marshal", this.marshallDataFormat);
            }
            if (!ObjectHelper.isEmpty((Object)this.unmarshallDataFormat)) {
                camelProperties.put("camel.kamelet.ckcUnMarshal.unmarshal", this.unmarshallDataFormat);
            }
            if (!ObjectHelper.isEmpty((Object)this.aggregationSize)) {
                camelProperties.put("camel.kamelet.ckcAggregator.aggregationSize", String.valueOf(this.aggregationSize));
            }
            if (!ObjectHelper.isEmpty((Object)this.aggregationTimeout)) {
                camelProperties.put("camel.kamelet.ckcAggregator.aggregationTimeout", String.valueOf(this.aggregationTimeout));
            }
            if (this.idempotencyEnabled) {
                switch (this.expressionType) {
                    case "body": {
                        camelProperties.put("camel.kamelet.ckcIdempotent.idempotentExpression", "${body}");
                        break;
                    }
                    case "header": {
                        camelProperties.put("camel.kamelet.ckcIdempotent.idempotentExpression", "${headers." + this.expressionHeader + "}");
                        break;
                    }
                }
                IdempotentRepository idempotentRepo = null;
                switch (this.idempotentRepositoryType) {
                    case "memory": {
                        idempotentRepo = MemoryIdempotentRepository.memoryIdempotentRepository((int)this.memoryDimension);
                        break;
                    }
                    case "kafka": {
                        idempotentRepo = new KafkaIdempotentRepository(this.idempotentRepositoryTopicName, this.idempotentRepositoryKafkaServers, this.idempotentRepositoryKafkaMaxCacheSize, this.idempotentRepositoryKafkaPollDuration);
                        break;
                    }
                }
                camelMain.getCamelContext().getRegistry().bind("ckcIdempotentRepository", (Object)idempotentRepo);
            }
            if (!ObjectHelper.isEmpty((Object)this.headersExcludePattern)) {
                camelProperties.put("camel.kamelet.ckcRemoveHeader.headersExcludePattern", this.headersExcludePattern);
            }
            List filteredProps = camelProperties.entrySet().stream().map(this::filterSensitive).collect(Collectors.toList());
            LOG.info("Setting initial properties in Camel context: [{}]", filteredProps);
            camelMain.setInitialProperties(camelProperties);
            camelMain.configure().addRoutesBuilder((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.routeTemplate("ckcMarshal").templateParameter("marshal", "dummyDataformat").from("kamelet:source").marshal("{{marshal}}")).to("kamelet:sink");
                    ((RouteDefinition)this.routeTemplate("ckcUnMarshal").templateParameter("unmarshal", "dummyDataformat").from("kamelet:source").marshal("{{unmarshal}}")).to("kamelet:sink");
                    ((AggregateDefinition)this.routeTemplate("ckcAggregator").templateParameter("aggregationStrategy", "aggregate").templateParameter("aggregationSize", "1").templateParameter("aggregationTimeout", String.valueOf(Long.MAX_VALUE)).from("kamelet:source").aggregate((Expression)this.constant(true)).aggregationStrategyRef("{{aggregationStrategy}}").completionSize("{{aggregationSize}}").completionTimeout("{{aggregationTimeout}}").to("kamelet:sink")).end();
                    this.routeTemplate("ckcIdempotent").templateParameter("idempotentExpression", "dummyExpression").templateParameter("idempotentRepository", "ckcIdempotentRepository").from("kamelet:source").idempotentConsumer((Expression)this.simple("{{idempotentExpression}}")).messageIdRepositoryRef("{{idempotentRepository}}").to("kamelet:sink");
                    ((RouteDefinition)this.routeTemplate("ckcRemoveHeader").templateParameter("headersExcludePattern", "(?!)").from("kamelet:source").removeHeaders("{{headersExcludePattern}}")).to("kamelet:sink");
                    this.routeTemplate("ckcSource").templateParameter("fromUrl").templateParameter("errorHandler", "ckcErrorHandler").from("{{fromUrl}}").errorHandler((ErrorHandlerFactory)new ErrorHandlerBuilderRef("{{errorHandler}}")).to("kamelet:sink");
                    this.routeTemplate("ckcSink").templateParameter("toUrl").templateParameter("errorHandler", "ckcErrorHandler").from("kamelet:source").errorHandler((ErrorHandlerFactory)new ErrorHandlerBuilderRef("{{errorHandler}}")).to("{{toUrl}}");
                    RouteDefinition rd = this.from(from);
                    if (!ObjectHelper.isEmpty((Object)marshallDataFormat)) {
                        rd = rd.kamelet("ckcMarshal");
                    }
                    if (!ObjectHelper.isEmpty((Object)unmarshallDataFormat)) {
                        rd = rd.kamelet("ckcUnMarshal");
                    }
                    if (this.getContext().getRegistry().lookupByName("aggregate") != null) {
                        rd = rd.kamelet("ckcAggregator");
                    }
                    if (idempotencyEnabled) {
                        rd = rd.kamelet("ckcIdempotent");
                    }
                    rd = rd.kamelet("ckcRemoveHeader");
                    rd.toD(to);
                }
            });
            return camelMain;
        }
    }
}

