/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.URISupport;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    private static final String INTEGRATION_VERSION = "camel.apache.org/v1";
    private static final String BINDING_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1";

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(final Node root) {
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root);
                if (target == null) {
                    return;
                }
                if (target instanceof Node) {
                    SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                    for (Node node : seq.getValue()) {
                        Object item = YamlRoutesBuilderLoader.this.getDeserializationContext().mandatoryResolve(node).construct(node);
                        this.doConfigure(item);
                    }
                } else {
                    this.doConfigure(target);
                }
            }

            private void doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route(route);
                } else if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                } else if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                } else if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                } else if (item instanceof ErrorHandlerBuilder) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerBuilder)item);
                } else if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteTemplateCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                } else if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRestCollection(), (CamelContext)this.getCamelContext());
                    this.getRestCollection().rest(definition);
                } else if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                }
            }

            public void configuration() throws Exception {
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root);
                if (target == null) {
                    return;
                }
                if (target instanceof Node) {
                    SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                    for (Node node : seq.getValue()) {
                        Object item = YamlRoutesBuilderLoader.this.getDeserializationContext().mandatoryResolve(node).construct(node);
                        this.doConfiguration(item);
                    }
                } else {
                    this.doConfiguration(target);
                }
            }

            private void doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteConfigurationCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                }
            }
        };
    }

    private Object preConfigureNode(Node root) throws Exception {
        Object target = root;
        if (Objects.equals(root.getNodeType(), NodeType.MAPPING)) {
            boolean binding;
            MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)root);
            boolean integration = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Integration");
            boolean bl = binding = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KameletBinding");
            if (integration) {
                target = this.preConfigureIntegration(root, target);
            } else if (binding) {
                target = this.preConfigureKameletBinding(root, target);
            }
        }
        return target;
    }

    private Object preConfigureIntegration(Node root, Object target) {
        Node routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flows");
        if (routes == null) {
            routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flow");
        }
        if (routes != null) {
            target = routes;
        }
        return target;
    }

    private Object preConfigureKameletBinding(Node root, Object target) throws Exception {
        RouteDefinition route = new RouteDefinition();
        String routeId = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/name"));
        if (routeId != null) {
            route.routeId(routeId);
        }
        MappingNode source = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/source"));
        MappingNode sink = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/sink"));
        if (source != null && sink != null) {
            String from = this.extractCamelEndpointUri(source);
            route.from(from);
            Node steps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/steps");
            if (steps != null) {
                SequenceNode sn = YamlDeserializerSupport.asSequenceNode((Node)steps);
                for (Node node : sn.getValue()) {
                    MappingNode step = YamlDeserializerSupport.asMappingNode((Node)node);
                    String uri = this.extractCamelEndpointUri(step);
                    if (uri == null) continue;
                    boolean kamelet = uri.startsWith("kamelet:");
                    if (kamelet) {
                        uri = uri.substring(8);
                        route.kamelet(uri);
                        continue;
                    }
                    route.to(uri);
                }
            }
            String to = this.extractCamelEndpointUri(sink);
            route.to(to);
            MappingNode errorHandler = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/errorHandler"));
            if (errorHandler != null) {
                NodeTuple nt = (NodeTuple)errorHandler.getValue().get(0);
                String ehName = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                DefaultErrorHandlerBuilder ehb = null;
                if ("dead-letter-channel".equals(ehName)) {
                    DeadLetterChannelBuilder dlch = new DeadLetterChannelBuilder();
                    MappingNode endpoint = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/endpoint"));
                    String dlq = this.extractCamelEndpointUri(endpoint);
                    dlch.setDeadLetterUri(dlq);
                    ehb = dlch;
                } else if ("log".equals(ehName)) {
                    ehb = new DefaultErrorHandlerBuilder();
                } else if ("none".equals(ehName)) {
                    route.errorHandler((ErrorHandlerFactory)new NoErrorHandlerBuilder());
                } else {
                    if ("bean".equals(ehName)) {
                        throw new IllegalArgumentException("Bean error handler is not supported");
                    }
                    if ("ref".equals(ehName)) {
                        throw new IllegalArgumentException("Ref error handler is not supported");
                    }
                }
                if (ehb != null) {
                    MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/parameters"));
                    Map params = YamlDeserializerSupport.asMap((Node)prop);
                    if (params != null) {
                        PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget((Object)ehb).withProperties(params).bind();
                    }
                    route.errorHandler((ErrorHandlerFactory)ehb);
                }
            }
            target = route;
        }
        return target;
    }

    private String extractCamelEndpointUri(MappingNode node) throws Exception {
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt((Node)node, (String)"/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode((Node)ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KafkaTopic");
        String uri = kamelet || strimzi ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri");
        MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/properties"));
        Map params = YamlDeserializerSupport.asMap((Node)prop);
        if (params != null && !params.isEmpty()) {
            String query = URISupport.createQueryString((Map)params);
            uri = uri + "?" + query;
        }
        if (kamelet) {
            return "kamelet:" + uri;
        }
        if (strimzi) {
            return "kafka:" + uri;
        }
        return uri;
    }
}

