/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.Protocol;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sqs.AmazonSQS;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.sns.SnsComponent;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SnsComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private SnsConfiguration getOrCreateConfiguration(SnsComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new SnsConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SnsComponent target = (SnsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonsnsclient": 
            case "amazonSNSClient": {
                this.getOrCreateConfiguration(target).setAmazonSNSClient((AmazonSNS)SnsComponentConfigurer.property((CamelContext)camelContext, AmazonSNS.class, (Object)value));
                return true;
            }
            case "amazonsqsclient": 
            case "amazonSQSClient": {
                this.getOrCreateConfiguration(target).setAmazonSQSClient((AmazonSQS)SnsComponentConfigurer.property((CamelContext)camelContext, AmazonSQS.class, (Object)value));
                return true;
            }
            case "autocreatetopic": 
            case "autoCreateTopic": {
                this.getOrCreateConfiguration(target).setAutoCreateTopic((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((SnsConfiguration)SnsComponentConfigurer.property((CamelContext)camelContext, SnsConfiguration.class, (Object)value));
                return true;
            }
            case "kmsmasterkeyid": 
            case "kmsMasterKeyId": {
                this.getOrCreateConfiguration(target).setKmsMasterKeyId((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagestructure": 
            case "messageStructure": {
                this.getOrCreateConfiguration(target).setMessageStructure((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)SnsComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)SnsComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "queueurl": 
            case "queueUrl": {
                this.getOrCreateConfiguration(target).setQueueUrl((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryptionenabled": 
            case "serverSideEncryptionEnabled": {
                this.getOrCreateConfiguration(target).setServerSideEncryptionEnabled((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subject": {
                this.getOrCreateConfiguration(target).setSubject((String)SnsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscribesnstosqs": 
            case "subscribeSNStoSQS": {
                this.getOrCreateConfiguration(target).setSubscribeSNStoSQS((Boolean)SnsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazonsnsclient": 
            case "amazonSNSClient": {
                return AmazonSNS.class;
            }
            case "amazonsqsclient": 
            case "amazonSQSClient": {
                return AmazonSQS.class;
            }
            case "autocreatetopic": 
            case "autoCreateTopic": {
                return Boolean.TYPE;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return SnsConfiguration.class;
            }
            case "kmsmasterkeyid": 
            case "kmsMasterKeyId": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "messagestructure": 
            case "messageStructure": {
                return String.class;
            }
            case "policy": {
                return String.class;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "queueurl": 
            case "queueUrl": {
                return String.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "serversideencryptionenabled": 
            case "serverSideEncryptionEnabled": {
                return Boolean.TYPE;
            }
            case "subject": {
                return String.class;
            }
            case "subscribesnstosqs": 
            case "subscribeSNStoSQS": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SnsComponent target = (SnsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonsnsclient": 
            case "amazonSNSClient": {
                return this.getOrCreateConfiguration(target).getAmazonSNSClient();
            }
            case "amazonsqsclient": 
            case "amazonSQSClient": {
                return this.getOrCreateConfiguration(target).getAmazonSQSClient();
            }
            case "autocreatetopic": 
            case "autoCreateTopic": {
                return this.getOrCreateConfiguration(target).isAutoCreateTopic();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "kmsmasterkeyid": 
            case "kmsMasterKeyId": {
                return this.getOrCreateConfiguration(target).getKmsMasterKeyId();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "messagestructure": 
            case "messageStructure": {
                return this.getOrCreateConfiguration(target).getMessageStructure();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "queueurl": 
            case "queueUrl": {
                return this.getOrCreateConfiguration(target).getQueueUrl();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "serversideencryptionenabled": 
            case "serverSideEncryptionEnabled": {
                return this.getOrCreateConfiguration(target).isServerSideEncryptionEnabled();
            }
            case "subject": {
                return this.getOrCreateConfiguration(target).getSubject();
            }
            case "subscribesnstosqs": 
            case "subscribeSNStoSQS": {
                return this.getOrCreateConfiguration(target).isSubscribeSNStoSQS();
            }
        }
        return null;
    }
}

