/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.services.sns.message.SnsMessageHandler;
import java.util.Date;

public abstract class SnsMessage {
    private final String messageId;
    private final String topicArn;
    private final Date timestamp;

    SnsMessage(Builder builder) {
        this.messageId = builder.messageId;
        this.topicArn = builder.topicArn;
        this.timestamp = builder.timestamp;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public abstract void handle(SnsMessageHandler var1);

    static abstract class Builder<SubclassT extends Builder> {
        private String messageId;
        private String topicArn;
        private Date timestamp;

        Builder() {
        }

        public SubclassT withMessageId(String messageId) {
            this.messageId = messageId;
            return this.getSubclass();
        }

        public SubclassT withTopicArn(String topicArn) {
            this.topicArn = topicArn;
            return this.getSubclass();
        }

        public SubclassT withTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this.getSubclass();
        }

        public abstract SnsMessage build();

        private SubclassT getSubclass() {
            return (SubclassT)this;
        }
    }
}

