/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import org.apache.camel.component.kafka.KafkaFetchRecords;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.kafka.common.errors.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectErrorStrategy
implements PollExceptionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectErrorStrategy.class);
    private final KafkaFetchRecords recordFetcher;
    private boolean retry = true;

    public ReconnectErrorStrategy(KafkaFetchRecords recordFetcher) {
        this.recordFetcher = recordFetcher;
    }

    @Override
    public void reset() {
        this.retry = true;
    }

    @Override
    public boolean canContinue() {
        return this.retry;
    }

    @Override
    public void handle(long partitionLastOffset, Exception exception) {
        if (exception instanceof AuthenticationException) {
            LOG.warn("Kafka reported a non-recoverable authentication error. The client will not reconnect");
            this.recordFetcher.setReconnect(false);
            this.recordFetcher.setConnected(false);
        } else {
            LOG.warn("Requesting the consumer to re-connect on the next run based on polling exception strategy");
            this.recordFetcher.setReconnect(true);
            this.recordFetcher.setConnected(false);
        }
        this.retry = false;
    }
}

