/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.BeanConfigInject;
import org.apache.camel.BeanInject;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelBeanPostProcessorInjector;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelBeanPostProcessor
implements CamelBeanPostProcessor,
CamelContextAware {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultCamelBeanPostProcessor.class);
    protected final List<CamelBeanPostProcessorInjector> beanPostProcessorInjectors = new ArrayList<CamelBeanPostProcessorInjector>();
    protected CamelPostProcessorHelper camelPostProcessorHelper;
    protected CamelContext camelContext;
    protected boolean enabled = true;
    protected boolean unbindEnabled;

    public DefaultCamelBeanPostProcessor() {
    }

    public DefaultCamelBeanPostProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isUnbindEnabled() {
        return this.unbindEnabled;
    }

    public void setUnbindEnabled(boolean unbindEnabled) {
        this.unbindEnabled = unbindEnabled;
    }

    public void addCamelBeanPostProjectInjector(CamelBeanPostProcessorInjector injector) {
        this.beanPostProcessorInjectors.add(injector);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing before initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (bean instanceof CamelContextAware) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            if (this.canSetCamelContext(bean, beanName)) {
                DeferredContextBinding deferredBinding = bean.getClass().getAnnotation(DeferredContextBinding.class);
                CamelContext context = this.getOrLookupCamelContext();
                if (context == null && deferredBinding == null) {
                    LOG.warn("No CamelContext defined yet so cannot inject into bean: {}", (Object)beanName);
                } else if (context != null) {
                    contextAware.setCamelContext(context);
                }
            }
        }
        if (this.enabled) {
            this.injectCamelContextPass(bean, beanName);
            this.injectFirstPass(bean, beanName, type -> !DefaultCamelBeanPostProcessor.isComplexUserType(type));
            this.injectSecondPass(bean, beanName, type -> DefaultCamelBeanPostProcessor.isComplexUserType(type));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing after initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (bean instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean;
    }

    public CamelContext getOrLookupCamelContext() {
        return this.camelContext;
    }

    public CamelPostProcessorHelper getPostProcessorHelper() {
        if (this.camelPostProcessorHelper == null) {
            this.camelPostProcessorHelper = new CamelPostProcessorHelper(this.getOrLookupCamelContext());
        }
        return this.camelPostProcessorHelper;
    }

    protected boolean canPostProcessBean(Object bean, String beanName) {
        if ("properties".equals(beanName)) {
            return false;
        }
        return bean != null;
    }

    protected boolean bindToRegistrySupported() {
        return true;
    }

    protected boolean canSetCamelContext(Object bean, String beanName) {
        CamelContextAware camelContextAware;
        CamelContext context;
        if (bean instanceof CamelContextAware && (context = (camelContextAware = (CamelContextAware)bean).getCamelContext()) != null) {
            LOG.trace("CamelContext already set on bean with id [{}]. Will keep existing CamelContext on bean.", (Object)beanName);
            return false;
        }
        return true;
    }

    protected void injectCamelContextPass(Object bean, String beanName) {
        this.injectFields(bean, beanName, type -> type.isAssignableFrom(CamelContext.class));
    }

    protected void injectFirstPass(Object bean, String beanName, Function<Class<?>, Boolean> filter) {
        this.injectFields(bean, beanName, filter);
        this.injectMethods(bean, beanName, filter);
        if (this.bindToRegistrySupported()) {
            this.injectClass(bean, beanName);
            this.injectNestedClasses(bean, beanName);
            this.injectBindToRegistryFields(bean, beanName, filter);
            this.injectBindToRegistryMethods(bean, beanName, filter);
        }
        this.injectEndpointFields(bean, beanName, filter);
    }

    protected void injectSecondPass(Object bean, String beanName, Function<Class<?>, Boolean> filter) {
        this.injectFields(bean, beanName, filter);
        if (this.bindToRegistrySupported()) {
            this.injectClass(bean, beanName);
            this.injectNestedClasses(bean, beanName);
            this.injectBindToRegistryFields(bean, beanName, filter);
            this.injectBindToRegistryMethods(bean, beanName, filter);
        }
        this.injectMethods(bean, beanName, filter);
        this.injectEndpointFields(bean, beanName, filter);
    }

    protected void injectEndpointFields(Object bean, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean.getClass(), field -> {
            Produce produce;
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
            if (endpointInject != null) {
                this.injectField(field, endpointInject.value(), endpointInject.property(), bean, beanName);
            }
            if ((produce = field.getAnnotation(Produce.class)) != null) {
                this.injectField(field, produce.value(), produce.property(), bean, beanName, produce.binding());
            }
        });
    }

    protected void injectFields(Object bean, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean.getClass(), field -> {
            BeanConfigInject beanConfigInject;
            BeanInject beanInject;
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
            if (propertyInject != null) {
                this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), propertyInject.separator(), bean);
            }
            if ((beanInject = field.getAnnotation(BeanInject.class)) != null) {
                this.injectFieldBean(field, beanInject.value(), bean, beanName);
            }
            if ((beanConfigInject = field.getAnnotation(BeanConfigInject.class)) != null) {
                this.injectFieldBeanConfig(field, beanConfigInject.value(), bean, beanName);
            }
            for (CamelBeanPostProcessorInjector injector : this.beanPostProcessorInjectors) {
                injector.onFieldInject(field, bean, beanName);
            }
        });
    }

    protected void injectBindToRegistryFields(Object bean, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean.getClass(), field -> {
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            BindToRegistry bind = field.getAnnotation(BindToRegistry.class);
            if (bind != null) {
                this.bindToRegistry(field, bind.value(), bean, beanName, bind.beanPostProcess(), false, bind.initMethod(), bind.destroyMethod());
            }
        });
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean, String beanName) {
        this.injectField(field, endpointUri, endpointProperty, bean, beanName, true);
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean, String beanName, boolean binding) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionValue(field.getType(), endpointUri, endpointProperty, field.getName(), bean, beanName, binding));
    }

    public void injectFieldBean(Field field, String name, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionBeanValue(field.getType(), name));
    }

    public void injectFieldBeanConfig(Field field, String name, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionBeanConfigValue(field.getType(), name));
    }

    public void injectFieldProperty(Field field, String propertyName, String propertyDefaultValue, String propertySeparator, Object bean) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionPropertyValue(field.getType(), field.getGenericType(), propertyName, propertyDefaultValue, propertySeparator));
    }

    protected void injectMethods(Object bean, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithMethods(bean.getClass(), method -> {
            if (accept != null && !((Boolean)accept.apply(method.getReturnType())).booleanValue()) {
                return;
            }
            this.setterInjection(method, bean, beanName);
            this.getPostProcessorHelper().consumerInjection(method, bean, beanName);
            for (CamelBeanPostProcessorInjector injector : this.beanPostProcessorInjectors) {
                injector.onMethodInject(method, bean, beanName);
            }
        });
    }

    protected void injectBindToRegistryMethods(Object bean, String beanName, Function<Class<?>, Boolean> accept) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionHelper.doWithMethods(bean.getClass(), method -> {
            if (accept != null && !((Boolean)accept.apply(method.getReturnType())).booleanValue()) {
                return;
            }
            BindToRegistry bind = method.getAnnotation(BindToRegistry.class);
            if (bind != null) {
                methods.add(method);
            }
        });
        methods.sort(Comparator.comparingInt(Method::getParameterCount));
        methods.sort((m1, m2) -> {
            Class<?>[] types1 = m1.getParameterTypes();
            Class<?>[] types2 = m2.getParameterTypes();
            if (types1.length == 0 && types2.length == 0) {
                return 0;
            }
            if (types1.length == 0) {
                return -1;
            }
            if (types2.length == 0) {
                return 1;
            }
            boolean usedByOthers1 = false;
            for (Class<?> clazz : types1) {
                usedByOthers1 |= methods.stream().anyMatch(m -> m.getParameterCount() > 0 && clazz.isAssignableFrom(m.getReturnType()));
            }
            boolean usedByOthers2 = false;
            for (Class<?> clazz : types2) {
                usedByOthers2 |= methods.stream().anyMatch(m -> m.getParameterCount() > 0 && clazz.isAssignableFrom(m.getReturnType()));
            }
            return Boolean.compare(usedByOthers1, usedByOthers2);
        });
        LOG.trace("Discovered {} @BindToRegistry methods", (Object)methods.size());
        methods.forEach(method -> {
            BindToRegistry bind = method.getAnnotation(BindToRegistry.class);
            this.bindToRegistry((Method)method, bind.value(), bean, beanName, bind.beanPostProcess(), bind.lazy(), bind.initMethod(), bind.destroyMethod());
        });
    }

    protected void injectClass(Object bean, String beanName) {
        Class<?> clazz = bean.getClass();
        BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
        if (ann != null) {
            this.bindToRegistry(clazz, ann.value(), bean, beanName, ann.beanPostProcess(), ann.lazy(), ann.initMethod(), ann.destroyMethod());
        }
    }

    protected void injectNestedClasses(Object bean, String beanName) {
        ReflectionHelper.doWithClasses(bean.getClass(), clazz -> {
            BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
            if (ann != null) {
                this.bindToRegistry(clazz, ann.value(), null, null, ann.beanPostProcess(), ann.lazy(), ann.initMethod(), ann.destroyMethod());
            }
        });
    }

    protected void setterInjection(Method method, Object bean, String beanName) {
        Produce produce;
        EndpointInject endpointInject;
        BeanConfigInject beanConfigInject;
        BeanInject beanInject;
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        if (propertyInject != null) {
            this.setterPropertyInjection(method, propertyInject.value(), propertyInject.defaultValue(), propertyInject.separator(), bean);
        }
        if ((beanInject = method.getAnnotation(BeanInject.class)) != null) {
            this.setterBeanInjection(method, beanInject.value(), bean, beanName);
        }
        if ((beanConfigInject = method.getAnnotation(BeanConfigInject.class)) != null) {
            this.setterBeanConfigInjection(method, beanConfigInject.value(), bean, beanName);
        }
        if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null) {
            this.setterInjection(method, bean, beanName, endpointInject.value(), endpointInject.property());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null) {
            this.setterInjection(method, bean, beanName, produce.value(), produce.property());
        }
    }

    public void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointProperty) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = this.getPostProcessorHelper().getInjectionValue(parameterTypes[0], endpointUri, endpointProperty, propertyName, bean, beanName);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    public void setterPropertyInjection(Method method, String propertyValue, String propertyDefaultValue, String propertySeparator, Object bean) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Class<?> type = parameterTypes[0];
            Type genericType = method.getGenericParameterTypes()[0];
            Object value = this.getPostProcessorHelper().getInjectionPropertyValue(type, genericType, propertyValue, propertyDefaultValue, propertySeparator);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    public void setterBeanInjection(Method method, String name, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            Object value = this.getPostProcessorHelper().getInjectionBeanValue(parameterTypes[0], name);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    public void setterBeanConfigInjection(Method method, String name, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            Object value = this.getPostProcessorHelper().getInjectionBeanConfigValue(parameterTypes[0], name);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    private void bindToRegistry(Class<?> clazz, String name, Object bean, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        if (ObjectHelper.isEmpty((String)name)) {
            name = clazz.getSimpleName();
        }
        boolean postProcess = beanPostProcess;
        if (bean == null) {
            if (lazy) {
                postProcess = false;
                bean = () -> {
                    Object answer = this.getOrLookupCamelContext().getInjector().newInstance(clazz);
                    if (answer != null && beanPostProcess) {
                        try {
                            CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
                            beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                            beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                        }
                    }
                    return answer;
                };
            } else {
                bean = this.getOrLookupCamelContext().getInjector().newInstance(clazz);
            }
        }
        if (this.unbindEnabled) {
            this.getOrLookupCamelContext().getRegistry().unbind(name);
        }
        if (ObjectHelper.isEmpty((String)initMethod)) {
            initMethod = CamelPostProcessorHelper.initMethodCandidate(bean);
        }
        if (ObjectHelper.isEmpty((String)destroyMethod)) {
            destroyMethod = CamelPostProcessorHelper.destroyMethodCandidate(bean);
        }
        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory((CamelContext)this.getOrLookupCamelContext()).createBindToRegistryFactory(name, bean, clazz, beanName, postProcess, initMethod, destroyMethod);
        task.run();
    }

    private void bindToRegistry(Field field, String name, Object bean, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        Supplier<Object> value;
        if (ObjectHelper.isEmpty((String)name)) {
            name = field.getName();
        }
        boolean postProcess = beanPostProcess;
        if (lazy) {
            postProcess = false;
            value = () -> {
                Object answer = ReflectionHelper.getField((Field)field, (Object)bean);
                if (answer != null && beanPostProcess) {
                    try {
                        CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
                        beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                        beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                    }
                }
                return answer;
            };
        } else {
            value = ReflectionHelper.getField((Field)field, (Object)bean);
        }
        if (value != null) {
            if (ObjectHelper.isEmpty((String)initMethod)) {
                initMethod = CamelPostProcessorHelper.initMethodCandidate(bean);
            }
            if (ObjectHelper.isEmpty((String)destroyMethod)) {
                destroyMethod = CamelPostProcessorHelper.destroyMethodCandidate(bean);
            }
            if (this.unbindEnabled) {
                this.getOrLookupCamelContext().getRegistry().unbind(name);
            }
            Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory((CamelContext)this.getOrLookupCamelContext()).createBindToRegistryFactory(name, value, field.getType(), beanName, postProcess, initMethod, destroyMethod);
            task.run();
        }
    }

    private void bindToRegistry(Method method, String name, Object bean, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        Object value;
        if (ObjectHelper.isEmpty((String)name)) {
            name = method.getName();
        }
        boolean postProcess = beanPostProcess;
        if (lazy) {
            postProcess = false;
            value = () -> {
                Object answer = this.getPostProcessorHelper().getInjectionBeanMethodValue(this.getOrLookupCamelContext(), method, bean, beanName, "BindToRegistry");
                if (answer != null && beanPostProcess) {
                    try {
                        CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
                        beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                        beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                    }
                }
                return answer;
            };
        } else {
            value = this.getPostProcessorHelper().getInjectionBeanMethodValue(this.getOrLookupCamelContext(), method, bean, beanName, "BindToRegistry");
        }
        if (value != null) {
            if (this.unbindEnabled) {
                this.getOrLookupCamelContext().getRegistry().unbind(name);
            }
            Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory((CamelContext)this.getOrLookupCamelContext()).createBindToRegistryFactory(name, value, method.getReturnType(), beanName, postProcess, initMethod, destroyMethod);
            task.run();
        }
    }

    private static boolean isComplexUserType(Class<?> type) {
        return type != null && !type.isPrimitive() && !type.getName().startsWith("java.");
    }
}

