/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataRedundancy {
    SINGLE_AVAILABILITY_ZONE("SingleAvailabilityZone"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataRedundancy> VALUE_MAP;
    private final String value;

    private DataRedundancy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataRedundancy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataRedundancy> knownValues() {
        EnumSet<DataRedundancy> knownValues = EnumSet.allOf(DataRedundancy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataRedundancy.class, DataRedundancy::toString);
    }
}

