/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonSchemaParser<T>
implements SchemaParser<JsonSchema, T> {
    public String artifactType() {
        return "JSON";
    }

    public JsonSchema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<JsonSchema>> resolvedReferences) {
        HashMap<String, String> referenceSchemas = new HashMap<String, String>();
        this.resolveReferences(resolvedReferences, referenceSchemas);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7, builder -> builder.schemaLoaders(schemaLoaders -> schemaLoaders.schemas(referenceSchemas)));
        return schemaFactory.getSchema(IoUtil.toString((byte[])rawSchema));
    }

    private void resolveReferences(Map<String, ParsedSchema<JsonSchema>> resolvedReferences, Map<String, String> referenceSchemas) {
        resolvedReferences.forEach((referenceName, schema) -> {
            if (schema.hasReferences()) {
                this.resolveReferences(schema.getSchemaReferences().stream().collect(Collectors.toMap(parsedSchema -> ((JsonSchema)parsedSchema.getParsedSchema()).getId(), parsedSchema -> parsedSchema)), referenceSchemas);
            }
            referenceSchemas.put(((JsonSchema)schema.getParsedSchema()).getId(), IoUtil.toString((byte[])schema.getRawSchema()));
        });
    }

    public ParsedSchema<JsonSchema> getSchemaFromData(Record<T> data) {
        return null;
    }

    public ParsedSchema<JsonSchema> getSchemaFromData(Record<T> data, boolean dereference) {
        return null;
    }

    public ParsedSchema<JsonSchema> getSchemaFromLocation(String location) {
        String rawSchema = IoUtil.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(location));
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        return new ParsedSchemaImpl().setParsedSchema((Object)factory.getSchema(IoUtil.toStream((String)rawSchema))).setRawSchema(rawSchema.getBytes());
    }

    public boolean supportsExtractSchemaFromData() {
        return false;
    }

    public boolean supportsGetSchemaFromLocation() {
        return true;
    }
}

