/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.impl.debugger.BacklogDebugger;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.impl.engine.CamelInternalPooledTaskFactory;
import org.apache.camel.impl.engine.CamelInternalTask;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInternalProcessor
extends DelegateAsyncProcessor
implements InternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelInternalProcessor.class);
    private static final Object[] EMPTY_STATES = new Object[0];
    final CamelContext camelContext;
    private final ReactiveExecutor reactiveExecutor;
    private final ShutdownStrategy shutdownStrategy;
    private final List<CamelInternalProcessorAdvice<?>> advices = new ArrayList();
    private byte statefulAdvices;
    private Object[] emptyStatefulStates;
    private PooledObjectFactory<CamelInternalTask> taskFactory;

    public CamelInternalProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.reactiveExecutor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.shutdownStrategy = camelContext.getShutdownStrategy();
    }

    public CamelInternalProcessor(CamelContext camelContext, Processor processor) {
        super(processor);
        this.camelContext = camelContext;
        this.reactiveExecutor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.shutdownStrategy = camelContext.getShutdownStrategy();
    }

    private CamelInternalProcessor(Logger log) {
        this.camelContext = null;
        this.reactiveExecutor = null;
        this.shutdownStrategy = null;
        log.trace("Loaded {}", (Object)AsyncAfterTask.class.getSimpleName());
    }

    protected void doBuild() throws Exception {
        boolean pooled = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().isPooled();
        if (pooled) {
            this.taskFactory = new CamelInternalPooledTaskFactory();
            int capacity = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().getCapacity();
            this.taskFactory.setCapacity(capacity);
            LOG.trace("Using TaskFactory: {}", this.taskFactory);
            this.emptyStatefulStates = new Object[this.statefulAdvices];
        }
        ServiceHelper.buildService((Object[])new Object[]{this.taskFactory, this.processor});
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.taskFactory, this.processor});
    }

    public void addAdvice(CamelInternalProcessorAdvice<?> advice) {
        this.advices.add(advice);
        this.advices.sort((Comparator<CamelInternalProcessorAdvice<?>>)OrderedComparator.get());
        if (advice.hasState()) {
            this.statefulAdvices = (byte)(this.statefulAdvices + 1);
        }
    }

    public <T> T getAdvice(Class<T> type) {
        for (CamelInternalProcessorAdvice<?> task : this.advices) {
            Object advice = CamelInternalProcessor.unwrap(task);
            if (!type.isInstance(advice)) continue;
            return type.cast(advice);
        }
        return null;
    }

    public void addRoutePolicyAdvice(List<RoutePolicy> routePolicyList) {
        this.addAdvice(new RoutePolicyAdvice(routePolicyList));
    }

    public void addRouteInflightRepositoryAdvice(InflightRepository inflightRepository, String routeId) {
        this.addAdvice(new RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), routeId));
    }

    public void addRouteLifecycleAdvice() {
        this.addAdvice(new RouteLifecycleAdvice());
    }

    public void addManagementInterceptStrategy(ManagementInterceptStrategy.InstrumentationProcessor processor) {
        this.addAdvice(CamelInternalProcessor.wrap(processor));
    }

    public void setRouteOnAdvices(Route route) {
        RouteLifecycleAdvice task2;
        RoutePolicyAdvice task = this.getAdvice(RoutePolicyAdvice.class);
        if (task != null) {
            task.setRoute(route);
        }
        if ((task2 = this.getAdvice(RouteLifecycleAdvice.class)) != null) {
            task2.setRoute(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback originalCallback) {
        boolean sync;
        boolean beforeAndAfter;
        Object[] states;
        CamelInternalTask afterTask;
        if (this.processor == null || exchange.isRouteStop()) {
            originalCallback.done(true);
            return true;
        }
        if (this.shutdownStrategy.isForceShutdown()) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
            LOG.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException(msg));
            }
            originalCallback.done(true);
            return true;
        }
        CamelInternalTask camelInternalTask = afterTask = this.taskFactory != null ? (CamelInternalTask)this.taskFactory.acquire() : null;
        if (afterTask == null) {
            states = this.statefulAdvices > 0 ? new Object[this.statefulAdvices] : EMPTY_STATES;
            afterTask = new AsyncAfterTask(states);
        } else {
            states = afterTask.getStates();
        }
        afterTask.prepare(exchange, originalCallback);
        int j = 0;
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice<?> task = this.advices.get(i);
            try {
                Object state = task.before(exchange);
                if (!task.hasState()) continue;
                states[j++] = state;
                continue;
            }
            catch (Throwable e) {
                exchange.setException(e);
                try {
                    originalCallback.done(true);
                }
                finally {
                    if (this.taskFactory != null) {
                        this.taskFactory.release((Object)afterTask);
                    }
                }
                return true;
            }
        }
        if (exchange.isTransacted()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                afterTask.done(true);
            }
            return true;
        }
        UnitOfWork uow = exchange.getUnitOfWork();
        CamelInternalTask async = afterTask;
        boolean bl = beforeAndAfter = uow != null && uow.isBeforeAfterProcess();
        if (beforeAndAfter) {
            async = uow.beforeProcess((Processor)this.processor, exchange, (AsyncCallback)async);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        if (!(sync = this.processor.process(exchange, (AsyncCallback)async))) {
            EventHelper.notifyExchangeAsyncProcessingStartedEvent((CamelContext)exchange.getContext(), (Exchange)exchange);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", new Object[]{sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange});
        }
        return sync;
    }

    public String toString() {
        return this.processor != null ? this.processor.toString() : super.toString();
    }

    public static <T> CamelInternalProcessorAdvice<T> wrap(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) {
        if (instrumentationProcessor instanceof CamelInternalProcessor) {
            return (CamelInternalProcessorAdvice)instrumentationProcessor;
        }
        return new CamelInternalProcessorAdviceWrapper<T>(instrumentationProcessor);
    }

    public static Object unwrap(CamelInternalProcessorAdvice<?> advice) {
        if (advice instanceof CamelInternalProcessorAdviceWrapper) {
            return ((CamelInternalProcessorAdviceWrapper)advice).unwrap();
        }
        return advice;
    }

    static class CamelInternalProcessorAdviceWrapper<T>
    implements CamelInternalProcessorAdvice<T>,
    Ordered {
        final ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor;

        public CamelInternalProcessorAdviceWrapper(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) {
            this.instrumentationProcessor = instrumentationProcessor;
        }

        ManagementInterceptStrategy.InstrumentationProcessor<T> unwrap() {
            return this.instrumentationProcessor;
        }

        public int getOrder() {
            return this.instrumentationProcessor.getOrder();
        }

        public T before(Exchange exchange) throws Exception {
            return (T)this.instrumentationProcessor.before(exchange);
        }

        public void after(Exchange exchange, T data) throws Exception {
            this.instrumentationProcessor.after(exchange, data);
        }
    }

    public static class TracingAdvice
    implements CamelInternalProcessorAdvice {
        private final Tracer tracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final Synchronization tracingAfterRoute;

        public TracingAdvice(Tracer tracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.tracer = tracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.tracingAfterRoute = routeDefinition != null ? new TracingAfterRoute(tracer, routeDefinition.getRouteId(), routeDefinition) : null;
        }

        public Object before(Exchange exchange) throws Exception {
            if (this.tracer.isEnabled()) {
                boolean contains;
                if (this.tracingAfterRoute != null && !(contains = exchange.getUnitOfWork().containsSynchronization(this.tracingAfterRoute))) {
                    this.tracer.traceBeforeRoute(this.routeDefinition, exchange);
                    ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(this.tracingAfterRoute);
                }
                this.tracer.traceBeforeNode(this.processorDefinition, exchange);
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (this.tracer.isEnabled()) {
                this.tracer.traceAfterNode(this.processorDefinition, exchange);
            }
        }

        public boolean hasState() {
            return false;
        }

        private static final class TracingAfterRoute
        extends SynchronizationAdapter {
            private final Tracer tracer;
            private final String routeId;
            private final NamedRoute node;

            private TracingAfterRoute(Tracer tracer, String routeId, NamedRoute node) {
                this.tracer = tracer;
                this.routeId = routeId;
                this.node = node;
            }

            public void onAfterRoute(Route route, Exchange exchange) {
                if (this.routeId.equals(route.getId())) {
                    this.tracer.traceAfterRoute(this.node, exchange);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                TracingAfterRoute that = (TracingAfterRoute)((Object)o);
                return this.routeId.equals(that.routeId);
            }

            public int hashCode() {
                return Objects.hash(this.routeId);
            }
        }
    }

    public static class DelayerAdvice
    implements CamelInternalProcessorAdvice {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final long delay;

        public DelayerAdvice(long delay) {
            this.delay = delay;
        }

        public Object before(Exchange exchange) throws Exception {
            try {
                this.log.trace("Sleeping for: {} millis", (Object)this.delay);
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.log.debug("Sleep interrupted");
                Thread.currentThread().interrupt();
                throw e;
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class StreamCachingAdvice
    implements CamelInternalProcessorAdvice<StreamCache>,
    Ordered {
        private final StreamCachingStrategy strategy;

        public StreamCachingAdvice(StreamCachingStrategy strategy) {
            this.strategy = strategy;
        }

        public StreamCache before(Exchange exchange) throws Exception {
            boolean failed;
            try {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                if (body instanceof StreamCache) {
                    StreamCache sc = (StreamCache)body;
                    sc.reset();
                    return sc;
                }
            }
            catch (Exception e) {
                StreamCacheException tce = new StreamCacheException(null, (Throwable)e);
                exchange.setException((Throwable)tce);
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(true);
            }
            Throwable cause = exchange.getException();
            if (cause == null) {
                cause = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
            }
            boolean bl = failed = cause != null && ObjectHelper.getException(StreamCacheException.class, (Throwable)cause) != null;
            if (!failed) {
                boolean disabled = ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).isStreamCacheDisabled();
                if (disabled) {
                    return null;
                }
                try {
                    StreamCache sc = this.strategy.cache(exchange);
                    if (sc != null) {
                        exchange.getIn().setBody((Object)sc);
                    }
                    return sc;
                }
                catch (Exception e) {
                    StreamCacheException tce = new StreamCacheException(exchange.getMessage().getBody(), (Throwable)e);
                    exchange.setException((Throwable)tce);
                    ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(true);
                }
            }
            return null;
        }

        public void after(Exchange exchange, StreamCache sc) throws Exception {
            Object body = exchange.getMessage().getBody();
            if (body instanceof StreamCache) {
                ((StreamCache)body).reset();
            }
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }

    public static class NodeHistoryAdvice
    implements CamelInternalProcessorAdvice {
        private final String id;
        private final String label;
        private final String source;

        public NodeHistoryAdvice(NamedNode definition) {
            this.id = definition.getId();
            this.label = definition.getLabel();
            this.source = LoggerHelper.getLineNumberLoggerName((Object)definition);
        }

        public String before(Exchange exchange) throws Exception {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            ee.setHistoryNodeId(this.id);
            ee.setHistoryNodeLabel(this.label);
            ee.setHistoryNodeSource(this.source);
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            ee.setHistoryNodeId(null);
            ee.setHistoryNodeLabel(null);
            ee.setHistoryNodeSource(null);
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class MessageHistoryAdvice
    implements CamelInternalProcessorAdvice<MessageHistory> {
        private final MessageHistoryFactory factory;
        private final NamedNode definition;
        private final String routeId;

        public MessageHistoryAdvice(MessageHistoryFactory factory, NamedNode definition) {
            this.factory = factory;
            this.definition = definition;
            this.routeId = CamelContextHelper.getRouteId((NamedNode)definition);
        }

        public MessageHistory before(Exchange exchange) throws Exception {
            MessageHistory history;
            String targetRouteId = this.routeId;
            if (targetRouteId == null) {
                targetRouteId = ExchangeHelper.getRouteId((Exchange)exchange);
            }
            if ((history = this.factory.newMessageHistory(targetRouteId, this.definition, System.currentTimeMillis(), exchange)) != null) {
                CopyOnWriteArrayList<MessageHistory> list = (CopyOnWriteArrayList<MessageHistory>)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
                if (list == null) {
                    list = new CopyOnWriteArrayList<MessageHistory>();
                    exchange.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, list);
                }
                list.add(history);
            }
            return history;
        }

        public void after(Exchange exchange, MessageHistory history) throws Exception {
            if (history != null) {
                history.nodeProcessingDone();
            }
        }
    }

    public static class ChildUnitOfWorkProcessorAdvice
    extends UnitOfWorkProcessorAdvice {
        private final UnitOfWork parent;

        public ChildUnitOfWorkProcessorAdvice(Route route, CamelContext camelContext, UnitOfWork parent) {
            super(route, camelContext);
            this.parent = parent;
        }

        @Override
        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return this.parent.createChildUnitOfWork(exchange);
        }
    }

    public static class UnitOfWorkProcessorAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        private final Route route;
        private String routeId;
        private UnitOfWorkFactory uowFactory;

        public UnitOfWorkProcessorAdvice(Route route, CamelContext camelContext) {
            this.route = route;
            if (route != null) {
                this.routeId = route.getRouteId();
            }
            this.uowFactory = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory();
            this.uowFactory.afterPropertiesConfigured(camelContext);
        }

        public UnitOfWork before(Exchange exchange) throws Exception {
            if (this.route != null && exchange.getFromRouteId() == null) {
                if (this.routeId == null) {
                    this.routeId = this.route.getRouteId();
                }
                ExtendedExchange ee = (ExtendedExchange)exchange;
                ee.setFromRouteId(this.routeId);
            }
            UnitOfWork created = null;
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow == null) {
                created = this.createUnitOfWork(exchange);
                ExtendedExchange ee = (ExtendedExchange)exchange;
                ee.setUnitOfWork(created);
                uow = created;
            } else if (uow.onPrepare(exchange)) {
                ExtendedExchange ee = (ExtendedExchange)exchange;
                ee.setUnitOfWork(uow);
                created = uow;
            }
            if (this.route != null) {
                uow.pushRoute(this.route);
            }
            return created;
        }

        public void after(Exchange exchange, UnitOfWork uow) throws Exception {
            UnitOfWork existing = exchange.getUnitOfWork();
            if (uow != null) {
                UnitOfWorkHelper.doneUow((UnitOfWork)uow, (Exchange)exchange);
            }
            if (this.route != null && existing != null) {
                existing.popRoute();
            }
        }

        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            if (this.uowFactory != null) {
                return this.uowFactory.createUnitOfWork(exchange);
            }
            return ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory().createUnitOfWork(exchange);
        }
    }

    public static final class DebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch>,
    Ordered {
        private final Debugger debugger;
        private final Processor target;
        private final NamedNode definition;

        public DebuggerAdvice(Debugger debugger, Processor target, NamedNode definition) {
            this.debugger = debugger;
            this.target = target;
            this.definition = definition;
        }

        public StopWatch before(Exchange exchange) throws Exception {
            this.debugger.beforeProcess(exchange, this.target, this.definition);
            return new StopWatch();
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            this.debugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
        }

        public int getOrder() {
            return 2147482647;
        }
    }

    public static final class BacklogDebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch>,
    Ordered {
        private final BacklogDebugger backlogDebugger;
        private final Processor target;
        private final NamedNode definition;

        public BacklogDebuggerAdvice(BacklogDebugger backlogDebugger, Processor target, NamedNode definition) {
            this.backlogDebugger = backlogDebugger;
            this.target = target;
            this.definition = definition;
        }

        public StopWatch before(Exchange exchange) throws Exception {
            return this.backlogDebugger.beforeProcess(exchange, this.target, this.definition);
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            if (stopWatch != null) {
                this.backlogDebugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
            }
        }

        public int getOrder() {
            return 2147482647;
        }
    }

    public static final class BacklogTracerAdvice
    implements CamelInternalProcessorAdvice,
    Ordered {
        private final BacklogTracer backlogTracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final boolean first;

        public BacklogTracerAdvice(BacklogTracer backlogTracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.backlogTracer = backlogTracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.first = first;
        }

        public Object before(Exchange exchange) throws Exception {
            if (this.backlogTracer.shouldTrace(this.processorDefinition, exchange)) {
                String routeId;
                long timestamp = System.currentTimeMillis();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                String messageAsXml = MessageHelper.dumpAsXml((Message)exchange.getIn(), (boolean)true, (int)4, (boolean)this.backlogTracer.isBodyIncludeStreams(), (boolean)this.backlogTracer.isBodyIncludeFiles(), (int)this.backlogTracer.getBodyMaxChars());
                String string = routeId = this.routeDefinition != null ? this.routeDefinition.getRouteId() : null;
                if (this.first) {
                    long created = exchange.getCreated();
                    DefaultBacklogTracerEventMessage pseudo = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), created, routeId, null, exchangeId, messageAsXml);
                    this.backlogTracer.traceEvent(pseudo);
                }
                DefaultBacklogTracerEventMessage event = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), timestamp, routeId, toNode, exchangeId, messageAsXml);
                this.backlogTracer.traceEvent(event);
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }

        public boolean hasState() {
            return false;
        }

        public int getOrder() {
            return 2147482646;
        }
    }

    public static class RoutePolicyAdvice
    implements CamelInternalProcessorAdvice {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final List<RoutePolicy> routePolicies;
        private Route route;

        public RoutePolicyAdvice(List<RoutePolicy> routePolicies) {
            this.routePolicies = routePolicies;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        boolean isRoutePolicyRunAllowed(RoutePolicy policy) {
            if (policy instanceof StatefulService) {
                StatefulService ss = (StatefulService)policy;
                return ss.isRunAllowed();
            }
            return true;
        }

        public Object before(Exchange exchange) throws Exception {
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeBegin(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeBegin on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (RoutePolicyAdvice.isCamelStopping(exchange.getContext())) {
                return;
            }
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeDone(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeDone on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
        }

        private static boolean isCamelStopping(CamelContext context) {
            if (context != null) {
                return context.isStopping() || context.isStopped();
            }
            return false;
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class RouteInflightRepositoryAdvice
    implements CamelInternalProcessorAdvice {
        private final InflightRepository inflightRepository;
        private final String id;

        public RouteInflightRepositoryAdvice(InflightRepository inflightRepository, String id) {
            this.inflightRepository = inflightRepository;
            this.id = id;
        }

        public Object before(Exchange exchange) throws Exception {
            this.inflightRepository.add(exchange, this.id);
            return null;
        }

        public void after(Exchange exchange, Object state) throws Exception {
            this.inflightRepository.remove(exchange, this.id);
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class RouteLifecycleAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private Route route;

        public void setRoute(Route route) {
            this.route = route;
        }

        public Object before(Exchange exchange) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.beforeRoute(exchange, this.route);
            }
            return null;
        }

        public void after(Exchange exchange, Object object) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.afterRoute(exchange, this.route);
            }
        }

        public boolean hasState() {
            return false;
        }
    }

    private final class AsyncAfterTask
    implements CamelInternalTask {
        private final Object[] states;
        private Exchange exchange;
        private AsyncCallback originalCallback;

        private AsyncAfterTask(Object[] states) {
            this.states = states;
        }

        @Override
        public void prepare(Exchange exchange, AsyncCallback originalCallback) {
            this.exchange = exchange;
            this.originalCallback = originalCallback;
        }

        @Override
        public Object[] getStates() {
            return this.states;
        }

        @Override
        public void reset() {
            System.arraycopy(CamelInternalProcessor.this.emptyStatefulStates, 0, this.states, 0, CamelInternalProcessor.this.statefulAdvices);
            this.exchange = null;
            this.originalCallback = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            try {
                int j = this.states.length - 1;
                for (int i = CamelInternalProcessor.this.advices.size() - 1; i >= 0; --i) {
                    CamelInternalProcessorAdvice<?> task = CamelInternalProcessor.this.advices.get(i);
                    Object state = null;
                    if (task.hasState()) {
                        state = this.states[j--];
                    }
                    try {
                        task.after(this.exchange, state);
                        continue;
                    }
                    catch (Throwable e) {
                        this.exchange.setException(e);
                    }
                }
            }
            finally {
                if (this.originalCallback != null) {
                    CamelInternalProcessor.this.reactiveExecutor.schedule((Runnable)this.originalCallback);
                }
                if (CamelInternalProcessor.this.taskFactory != null) {
                    CamelInternalProcessor.this.taskFactory.release((Object)this);
                }
            }
        }
    }
}

