/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.internal.crt.CrtCredentialsProviderAdapter;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
public class S3NativeClientConfiguration
implements SdkAutoCloseable {
    private static final long DEFAULT_PART_SIZE_IN_BYTES = 0x800000L;
    private static final long DEFAULT_TARGET_THROUGHPUT_IN_GBPS = 5L;
    private final String signingRegion;
    private final ClientBootstrap clientBootstrap;
    private final CrtCredentialsProviderAdapter credentialProviderAdapter;
    private final CredentialsProvider credentialsProvider;
    private final long partSizeInBytes;
    private final double targetThroughputInGbps;
    private final int maxConcurrency;
    private final URI endpointOverride;
    private final Executor futureCompletionExecutor;

    public S3NativeClientConfiguration(Builder builder) {
        this.signingRegion = builder.signingRegion == null ? DefaultAwsRegionProviderChain.builder().build().getRegion().id() : builder.signingRegion;
        this.clientBootstrap = new ClientBootstrap(null, null);
        this.credentialProviderAdapter = builder.credentialsProvider == null ? new CrtCredentialsProviderAdapter((AwsCredentialsProvider)DefaultCredentialsProvider.create()) : new CrtCredentialsProviderAdapter(builder.credentialsProvider);
        this.credentialsProvider = this.credentialProviderAdapter.crtCredentials();
        this.partSizeInBytes = builder.partSizeInBytes == null ? 0x800000L : builder.partSizeInBytes;
        this.targetThroughputInGbps = builder.targetThroughputInGbps == null ? 5.0 : builder.targetThroughputInGbps;
        this.maxConcurrency = builder.maxConcurrency == null ? 0 : builder.maxConcurrency;
        this.endpointOverride = builder.endpointOverride;
        this.futureCompletionExecutor = this.resolveAsyncFutureCompletionExecutor(builder.asynConfiguration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String signingRegion() {
        return this.signingRegion;
    }

    public ClientBootstrap clientBootstrap() {
        return this.clientBootstrap;
    }

    public CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public long partSizeBytes() {
        return this.partSizeInBytes;
    }

    public double targetThroughputInGbps() {
        return this.targetThroughputInGbps;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public URI endpointOverride() {
        return this.endpointOverride;
    }

    public Executor futureCompletionExecutor() {
        return this.futureCompletionExecutor;
    }

    private Executor resolveAsyncFutureCompletionExecutor(ClientAsyncConfiguration config) {
        Supplier<Executor> defaultExecutor = () -> {
            int processors = Runtime.getRuntime().availableProcessors();
            int corePoolSize = Math.max(8, processors);
            int maxPoolSize = Math.max(64, processors * 2);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("sdk-async-response").build());
            executor.allowCoreThreadTimeOut(true);
            return executor;
        };
        return Optional.ofNullable(config).map(c -> (Executor)c.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR)).orElseGet(defaultExecutor);
    }

    public void close() {
        this.clientBootstrap.close();
        this.credentialProviderAdapter.close();
        this.shutdownIfExecutorService(this.futureCompletionExecutor);
    }

    private void shutdownIfExecutorService(Object object) {
        if (object instanceof ExecutorService) {
            ExecutorService executor = (ExecutorService)object;
            executor.shutdown();
        }
    }

    public static final class Builder {
        private String signingRegion;
        private AwsCredentialsProvider credentialsProvider;
        private Long partSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;
        private URI endpointOverride;
        private ClientAsyncConfiguration asynConfiguration;

        private Builder() {
        }

        public Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public Builder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        public Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        public Builder asyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
            this.asynConfiguration = asyncConfiguration;
            return this;
        }

        public S3NativeClientConfiguration build() {
            return new S3NativeClientConfiguration(this);
        }
    }
}

