/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="transform")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransformDefinition
extends ExpressionNode {
    @XmlAttribute
    private String fromType;
    @XmlAttribute
    private String toType;

    public TransformDefinition() {
    }

    public TransformDefinition(Expression expression) {
        super(expression);
    }

    public TransformDefinition(DataType fromType, DataType toType) {
        this.fromType = fromType.getFullName();
        this.toType = toType.getFullName();
    }

    public String toString() {
        if (this.toType != null) {
            if (this.fromType != null) {
                return "Transform[" + this.fromType + ", " + this.toType + "]";
            }
            return "Transform[" + this.toType + "]";
        }
        return "Transform[" + String.valueOf(this.getExpression()) + "]";
    }

    public String getShortName() {
        return "transform";
    }

    @Override
    public String getLabel() {
        if (this.toType != null) {
            if (this.fromType != null) {
                return "transform[" + this.fromType + ", " + this.toType + "]";
            }
            return "transform[" + this.toType + "]";
        }
        return "transform[" + String.valueOf(this.getExpression()) + "]";
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public String getFromType() {
        return this.fromType;
    }

    public void setToType(String toType) {
        this.toType = toType;
    }

    public String getToType() {
        return this.toType;
    }
}

