/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.exceptions.InvalidStateException;
import software.amazon.kinesis.exceptions.ShutdownException;
import software.amazon.kinesis.lifecycle.events.InitializationInput;
import software.amazon.kinesis.lifecycle.events.LeaseLostInput;
import software.amazon.kinesis.lifecycle.events.ProcessRecordsInput;
import software.amazon.kinesis.lifecycle.events.ShardEndedInput;
import software.amazon.kinesis.lifecycle.events.ShutdownRequestedInput;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.NullMetricsFactory;
import software.amazon.kinesis.processor.ShardRecordProcessor;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class KclKinesis2Consumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KclKinesis2Consumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private Scheduler schedulerKcl;

    public KclKinesis2Consumer(Kinesis2Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public Kinesis2Endpoint getEndpoint() {
        return (Kinesis2Endpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        DynamoDbAsyncClientBuilder clientBuilder;
        super.doStart();
        LOG.debug("Starting KCL Consumer");
        DynamoDbAsyncClient dynamoDbAsyncClient = null;
        CloudWatchAsyncClient cloudWatchAsyncClient = null;
        KinesisAsyncClient kinesisAsyncClient = this.getEndpoint().getConfiguration().getAmazonKinesisAsyncClient();
        Kinesis2Configuration configuration = this.getEndpoint().getConfiguration();
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getDynamoDbAsyncClient())) {
            clientBuilder = DynamoDbAsyncClient.builder();
            if (ObjectHelper.isNotEmpty((String)configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getSecretKey())) {
                clientBuilder = (DynamoDbAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey())));
            } else if (ObjectHelper.isNotEmpty((String)configuration.getProfileCredentialsName())) {
                clientBuilder = (DynamoDbAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)configuration.getProfileCredentialsName()));
            } else if (ObjectHelper.isNotEmpty((String)configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getSecretKey()) && ObjectHelper.isNotEmpty((String)configuration.getSessionToken())) {
                clientBuilder = (DynamoDbAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey(), (String)configuration.getSessionToken())));
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion())) {
                clientBuilder = (DynamoDbAsyncClientBuilder)clientBuilder.region(Region.of((String)configuration.getRegion()));
            }
            dynamoDbAsyncClient = (DynamoDbAsyncClient)clientBuilder.build();
        } else {
            dynamoDbAsyncClient = this.getEndpoint().getConfiguration().getDynamoDbAsyncClient();
        }
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getCloudWatchAsyncClient())) {
            clientBuilder = CloudWatchAsyncClient.builder();
            if (ObjectHelper.isNotEmpty((String)configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getSecretKey())) {
                clientBuilder = (CloudWatchAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey())));
            } else if (ObjectHelper.isNotEmpty((String)configuration.getProfileCredentialsName())) {
                clientBuilder = (CloudWatchAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)configuration.getProfileCredentialsName()));
            } else if (ObjectHelper.isNotEmpty((String)configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getSecretKey()) && ObjectHelper.isNotEmpty((String)configuration.getSessionToken())) {
                clientBuilder = (CloudWatchAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey(), (String)configuration.getSessionToken())));
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion())) {
                clientBuilder = (CloudWatchAsyncClientBuilder)clientBuilder.region(Region.of((String)configuration.getRegion()));
            }
            cloudWatchAsyncClient = (CloudWatchAsyncClient)clientBuilder.build();
        } else {
            cloudWatchAsyncClient = this.getEndpoint().getConfiguration().getCloudWatchAsyncClient();
        }
        this.executor = this.getEndpoint().createExecutor();
        this.executor.submit(new KclKinesisConsumingTask(configuration.getStreamName(), configuration.getApplicationName(), kinesisAsyncClient, dynamoDbAsyncClient, cloudWatchAsyncClient, configuration.isKclDisableCloudwatchMetricsExport()));
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping KCL Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        if (this.schedulerKcl != null) {
            CompletableFuture gracefulShutdownFuture = this.schedulerKcl.startGracefulShutdown();
            LOG.info("Waiting up to 20 seconds for scheduler shutdown to complete.");
            try {
                gracefulShutdownFuture.get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted while waiting for graceful shutdown. Continuing.");
            }
            catch (ExecutionException e) {
                LOG.debug("Exception while executing graceful shutdown.", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.debug("Timeout while waiting for shutdown.  Scheduler may not have exited.");
            }
            LOG.debug("Completed, shutting down now.");
        }
        this.executor = null;
        super.doStop();
    }

    class KclKinesisConsumingTask
    implements Runnable {
        private final KinesisAsyncClient kinesisAsyncClient;
        private final DynamoDbAsyncClient dynamoDbAsyncClient;
        private final CloudWatchAsyncClient cloudWatchAsyncClient;
        private final String streamName;
        private final String applicationName;
        private final boolean disableMetricsExport;

        KclKinesisConsumingTask(String streamName, String applicationName, KinesisAsyncClient kinesisAsyncClient, DynamoDbAsyncClient dynamoDbAsyncClient, CloudWatchAsyncClient cloudWatchAsyncClient, boolean disableMetricsExport) {
            this.cloudWatchAsyncClient = cloudWatchAsyncClient;
            this.dynamoDbAsyncClient = dynamoDbAsyncClient;
            this.kinesisAsyncClient = kinesisAsyncClient;
            this.streamName = streamName;
            this.applicationName = applicationName != null ? applicationName : streamName;
            this.disableMetricsExport = disableMetricsExport;
        }

        @Override
        public void run() {
            try {
                Scheduler scheduler;
                ConfigsBuilder configsBuilder = new ConfigsBuilder(this.streamName, this.applicationName, this.kinesisAsyncClient, this.dynamoDbAsyncClient, this.cloudWatchAsyncClient, "KclKinesisConsumingTask-" + UUID.randomUUID().toString(), (ShardRecordProcessorFactory)new CamelKinesisRecordProcessorFactory());
                KclKinesis2Consumer.this.schedulerKcl = scheduler = new Scheduler(configsBuilder.checkpointConfig(), configsBuilder.coordinatorConfig(), configsBuilder.leaseManagementConfig(), configsBuilder.lifecycleConfig(), this.disableMetricsExport ? configsBuilder.metricsConfig().metricsLevel(MetricsLevel.NONE).metricsFactory((MetricsFactory)new NullMetricsFactory()) : configsBuilder.metricsConfig(), configsBuilder.processorConfig(), configsBuilder.retrievalConfig().retrievalSpecificConfig((RetrievalSpecificConfig)new PollingConfig(KclKinesis2Consumer.this.getEndpoint().getConfiguration().getStreamName(), this.kinesisAsyncClient)));
                Thread schedulerThread = new Thread((Runnable)scheduler);
                schedulerThread.start();
            }
            catch (Exception e) {
                KclKinesis2Consumer.this.getExceptionHandler().handleException("Error during processing", (Throwable)e);
            }
        }
    }

    class CamelKinesisRecordProcessor
    implements ShardRecordProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(CamelKinesisRecordProcessor.class);
        private String shardId;
        private Kinesis2Endpoint endpoint;

        public CamelKinesisRecordProcessor(Kinesis2Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void initialize(InitializationInput initializationInput) {
            this.shardId = initializationInput.shardId();
            LOG.debug("Initializing @ Sequence: {}", (Object)initializationInput.extendedSequenceNumber());
        }

        public void processRecords(ProcessRecordsInput processRecordsInput) {
            try {
                LOG.debug("Processing {} record(s)", (Object)processRecordsInput.records().size());
                processRecordsInput.records().forEach(r -> {
                    try {
                        KclKinesis2Consumer.this.processor.process(this.createExchange((KinesisClientRecord)r, this.shardId));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("Caught throwable while processing records. Aborting.");
            }
        }

        public void leaseLost(LeaseLostInput leaseLostInput) {
            LOG.debug("Lost lease, so terminating.");
        }

        public void shardEnded(ShardEndedInput shardEndedInput) {
            try {
                LOG.debug("Reached shard end checkpointing.");
                shardEndedInput.checkpointer().checkpoint();
            }
            catch (InvalidStateException | ShutdownException e) {
                LOG.error("Exception while checkpointing at shard end. Giving up.", e);
            }
        }

        public void shutdownRequested(ShutdownRequestedInput shutdownRequestedInput) {
            try {
                LOG.debug("Scheduler is shutting down, checkpointing.");
                shutdownRequestedInput.checkpointer().checkpoint();
            }
            catch (InvalidStateException | ShutdownException e) {
                LOG.error("Exception while checkpointing at requested shutdown. Giving up.", e);
            }
        }

        protected Exchange createExchange(KinesisClientRecord dataRecord, String shardId) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getMessage().setBody((Object)dataRecord.data());
            exchange.getMessage().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)dataRecord.approximateArrivalTimestamp());
            exchange.getMessage().setHeader("CamelAwsKinesisPartitionKey", (Object)dataRecord.partitionKey());
            exchange.getMessage().setHeader("CamelAwsKinesisSequenceNumber", (Object)dataRecord.sequenceNumber());
            exchange.getMessage().setHeader("CamelAwsKinesisShardId", (Object)shardId);
            if (dataRecord.approximateArrivalTimestamp() != null) {
                long ts = dataRecord.approximateArrivalTimestamp().getEpochSecond() * 1000L;
                exchange.getMessage().setHeader("CamelMessageTimestamp", (Object)ts);
            }
            return exchange;
        }
    }

    private class CamelKinesisRecordProcessorFactory
    implements ShardRecordProcessorFactory {
        private CamelKinesisRecordProcessorFactory() {
        }

        public ShardRecordProcessor shardRecordProcessor() {
            return new CamelKinesisRecordProcessor(KclKinesis2Consumer.this.getEndpoint());
        }
    }
}

