/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.HECEndpointType;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration;
import software.amazon.awssdk.services.firehose.model.SplunkBufferingHints;
import software.amazon.awssdk.services.firehose.model.SplunkRetryOptions;
import software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SplunkDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SplunkDestinationConfiguration> {
    private static final SdkField<String> HEC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HECEndpoint").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::hecEndpoint)).setter(SplunkDestinationConfiguration.setter(Builder::hecEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECEndpoint").build()}).build();
    private static final SdkField<String> HEC_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HECEndpointType").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::hecEndpointTypeAsString)).setter(SplunkDestinationConfiguration.setter(Builder::hecEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECEndpointType").build()}).build();
    private static final SdkField<String> HEC_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HECToken").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::hecToken)).setter(SplunkDestinationConfiguration.setter(Builder::hecToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECToken").build()}).build();
    private static final SdkField<Integer> HEC_ACKNOWLEDGMENT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HECAcknowledgmentTimeoutInSeconds").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::hecAcknowledgmentTimeoutInSeconds)).setter(SplunkDestinationConfiguration.setter(Builder::hecAcknowledgmentTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECAcknowledgmentTimeoutInSeconds").build()}).build();
    private static final SdkField<SplunkRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::retryOptions)).setter(SplunkDestinationConfiguration.setter(Builder::retryOptions)).constructor(SplunkRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::s3BackupModeAsString)).setter(SplunkDestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::s3Configuration)).setter(SplunkDestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::processingConfiguration)).setter(SplunkDestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::cloudWatchLoggingOptions)).setter(SplunkDestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<SplunkBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::bufferingHints)).setter(SplunkDestinationConfiguration.setter(Builder::bufferingHints)).constructor(SplunkBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<SecretsManagerConfiguration> SECRETS_MANAGER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManagerConfiguration").getter(SplunkDestinationConfiguration.getter(SplunkDestinationConfiguration::secretsManagerConfiguration)).setter(SplunkDestinationConfiguration.setter(Builder::secretsManagerConfiguration)).constructor(SecretsManagerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEC_ENDPOINT_FIELD, HEC_ENDPOINT_TYPE_FIELD, HEC_TOKEN_FIELD, HEC_ACKNOWLEDGMENT_TIMEOUT_IN_SECONDS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, BUFFERING_HINTS_FIELD, SECRETS_MANAGER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SplunkDestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hecEndpoint;
    private final String hecEndpointType;
    private final String hecToken;
    private final Integer hecAcknowledgmentTimeoutInSeconds;
    private final SplunkRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final SplunkBufferingHints bufferingHints;
    private final SecretsManagerConfiguration secretsManagerConfiguration;

    private SplunkDestinationConfiguration(BuilderImpl builder) {
        this.hecEndpoint = builder.hecEndpoint;
        this.hecEndpointType = builder.hecEndpointType;
        this.hecToken = builder.hecToken;
        this.hecAcknowledgmentTimeoutInSeconds = builder.hecAcknowledgmentTimeoutInSeconds;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.bufferingHints = builder.bufferingHints;
        this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
    }

    public final String hecEndpoint() {
        return this.hecEndpoint;
    }

    public final HECEndpointType hecEndpointType() {
        return HECEndpointType.fromValue(this.hecEndpointType);
    }

    public final String hecEndpointTypeAsString() {
        return this.hecEndpointType;
    }

    public final String hecToken() {
        return this.hecToken;
    }

    public final Integer hecAcknowledgmentTimeoutInSeconds() {
        return this.hecAcknowledgmentTimeoutInSeconds;
    }

    public final SplunkRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final SplunkS3BackupMode s3BackupMode() {
        return SplunkS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final SplunkBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final SecretsManagerConfiguration secretsManagerConfiguration() {
        return this.secretsManagerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecAcknowledgmentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplunkDestinationConfiguration)) {
            return false;
        }
        SplunkDestinationConfiguration other = (SplunkDestinationConfiguration)obj;
        return Objects.equals(this.hecEndpoint(), other.hecEndpoint()) && Objects.equals(this.hecEndpointTypeAsString(), other.hecEndpointTypeAsString()) && Objects.equals(this.hecToken(), other.hecToken()) && Objects.equals(this.hecAcknowledgmentTimeoutInSeconds(), other.hecAcknowledgmentTimeoutInSeconds()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.secretsManagerConfiguration(), other.secretsManagerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SplunkDestinationConfiguration").add("HECEndpoint", (Object)this.hecEndpoint()).add("HECEndpointType", (Object)this.hecEndpointTypeAsString()).add("HECToken", (Object)this.hecToken()).add("HECAcknowledgmentTimeoutInSeconds", (Object)this.hecAcknowledgmentTimeoutInSeconds()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("BufferingHints", (Object)this.bufferingHints()).add("SecretsManagerConfiguration", (Object)this.secretsManagerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HECEndpoint": {
                return Optional.ofNullable(clazz.cast(this.hecEndpoint()));
            }
            case "HECEndpointType": {
                return Optional.ofNullable(clazz.cast(this.hecEndpointTypeAsString()));
            }
            case "HECToken": {
                return Optional.ofNullable(clazz.cast(this.hecToken()));
            }
            case "HECAcknowledgmentTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.hecAcknowledgmentTimeoutInSeconds()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "SecretsManagerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HECEndpoint", HEC_ENDPOINT_FIELD);
        map.put("HECEndpointType", HEC_ENDPOINT_TYPE_FIELD);
        map.put("HECToken", HEC_TOKEN_FIELD);
        map.put("HECAcknowledgmentTimeoutInSeconds", HEC_ACKNOWLEDGMENT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("SecretsManagerConfiguration", SECRETS_MANAGER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SplunkDestinationConfiguration, T> g) {
        return obj -> g.apply((SplunkDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hecEndpoint;
        private String hecEndpointType;
        private String hecToken;
        private Integer hecAcknowledgmentTimeoutInSeconds;
        private SplunkRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private SplunkBufferingHints bufferingHints;
        private SecretsManagerConfiguration secretsManagerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SplunkDestinationConfiguration model) {
            this.hecEndpoint(model.hecEndpoint);
            this.hecEndpointType(model.hecEndpointType);
            this.hecToken(model.hecToken);
            this.hecAcknowledgmentTimeoutInSeconds(model.hecAcknowledgmentTimeoutInSeconds);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.bufferingHints(model.bufferingHints);
            this.secretsManagerConfiguration(model.secretsManagerConfiguration);
        }

        public final String getHecEndpoint() {
            return this.hecEndpoint;
        }

        public final void setHecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
        }

        @Override
        public final Builder hecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
            return this;
        }

        public final String getHecEndpointType() {
            return this.hecEndpointType;
        }

        public final void setHecEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
        }

        @Override
        public final Builder hecEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
            return this;
        }

        @Override
        public final Builder hecEndpointType(HECEndpointType hecEndpointType) {
            this.hecEndpointType(hecEndpointType == null ? null : hecEndpointType.toString());
            return this;
        }

        public final String getHecToken() {
            return this.hecToken;
        }

        public final void setHecToken(String hecToken) {
            this.hecToken = hecToken;
        }

        @Override
        public final Builder hecToken(String hecToken) {
            this.hecToken = hecToken;
            return this;
        }

        public final Integer getHecAcknowledgmentTimeoutInSeconds() {
            return this.hecAcknowledgmentTimeoutInSeconds;
        }

        public final void setHecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
        }

        @Override
        public final Builder hecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
            return this;
        }

        public final SplunkRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(SplunkRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(SplunkRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SplunkS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final SplunkBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(SplunkBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(SplunkBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final SecretsManagerConfiguration.Builder getSecretsManagerConfiguration() {
            return this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerConfiguration(SecretsManagerConfiguration.BuilderImpl secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration != null ? secretsManagerConfiguration.build() : null;
        }

        @Override
        public final Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration;
            return this;
        }

        public SplunkDestinationConfiguration build() {
            return new SplunkDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SplunkDestinationConfiguration> {
        public Builder hecEndpoint(String var1);

        public Builder hecEndpointType(String var1);

        public Builder hecEndpointType(HECEndpointType var1);

        public Builder hecToken(String var1);

        public Builder hecAcknowledgmentTimeoutInSeconds(Integer var1);

        public Builder retryOptions(SplunkRetryOptions var1);

        default public Builder retryOptions(Consumer<SplunkRetryOptions.Builder> retryOptions) {
            return this.retryOptions((SplunkRetryOptions)((SplunkRetryOptions.Builder)SplunkRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(SplunkS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder bufferingHints(SplunkBufferingHints var1);

        default public Builder bufferingHints(Consumer<SplunkBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((SplunkBufferingHints)((SplunkBufferingHints.Builder)SplunkBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder secretsManagerConfiguration(SecretsManagerConfiguration var1);

        default public Builder secretsManagerConfiguration(Consumer<SecretsManagerConfiguration.Builder> secretsManagerConfiguration) {
            return this.secretsManagerConfiguration((SecretsManagerConfiguration)((SecretsManagerConfiguration.Builder)SecretsManagerConfiguration.builder().applyMutation(secretsManagerConfiguration)).build());
        }
    }
}

