/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.headers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Processor;

public class DuplicateNamingHeaders
implements Processor {
    String prefix;
    String renamingPrefix;
    String selectedHeaders;
    String mode = "all";

    public DuplicateNamingHeaders() {
    }

    public DuplicateNamingHeaders(String prefix, String renamingPrefix, String selectedHeaders, String mode) {
        this.prefix = prefix;
        this.renamingPrefix = renamingPrefix;
        this.selectedHeaders = selectedHeaders;
        this.mode = mode;
    }

    public void process(Exchange ex) throws InvalidPayloadException {
        Map originalHeaders = ex.getMessage().getHeaders();
        HashMap newHeaders = new HashMap();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (this.prefix != null && this.mode.equalsIgnoreCase("all")) {
                if (!key.startsWith(this.prefix)) continue;
                String newKey = key.replaceFirst(this.prefix, this.renamingPrefix);
                String subKey = newKey.substring(this.renamingPrefix.length());
                String suffix = subKey.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), ".").toLowerCase();
                newHeaders.put(this.renamingPrefix + suffix, val);
                continue;
            }
            if (this.selectedHeaders == null || !this.mode.equalsIgnoreCase("filtering")) continue;
            List<String> headerList = Arrays.asList(this.selectedHeaders.split(","));
            for (String header : headerList) {
                if (!key.equalsIgnoreCase(header)) continue;
                String newKey = key.replaceFirst(this.prefix, this.renamingPrefix);
                String subKey = newKey.substring(this.renamingPrefix.length());
                String suffix = subKey.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), ".").toLowerCase();
                newHeaders.put(this.renamingPrefix + suffix, val);
            }
        }
        originalHeaders.putAll(newHeaders);
        ex.getMessage().setHeaders(originalHeaders);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRenamingPrefix(String renamingPrefix) {
        this.renamingPrefix = renamingPrefix;
    }

    public void setSelectedHeaders(String selectedHeaders) {
        this.selectedHeaders = selectedHeaders;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

